/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server;

import java.util.ArrayList;
import net.minestom.server.adventure.ComponentHolder;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.SendablePacket;
import net.minestom.server.utils.PacketUtils;
import org.jetbrains.annotations.NotNull;

public sealed interface ServerPacket
extends NetworkBuffer.Writer,
SendablePacket {
    default public int getId(@NotNull ConnectionState state) {
        int id;
        switch (state) {
            default: {
                throw new MatchException(null, null);
            }
            case HANDSHAKE: {
                int n = -1;
                break;
            }
            case CONFIGURATION: {
                int n;
                ServerPacket serverPacket = this;
                if (serverPacket instanceof Configuration) {
                    Configuration configuration = (Configuration)serverPacket;
                    n = configuration.configurationId();
                    break;
                }
                n = -1;
                break;
            }
            case STATUS: {
                int n;
                ServerPacket serverPacket = this;
                if (serverPacket instanceof Status) {
                    Status status = (Status)serverPacket;
                    n = status.statusId();
                    break;
                }
                n = -1;
                break;
            }
            case LOGIN: {
                int n;
                ServerPacket serverPacket = this;
                if (serverPacket instanceof Login) {
                    Login login = (Login)serverPacket;
                    n = login.loginId();
                    break;
                }
                n = -1;
                break;
            }
            case PLAY: {
                int n;
                ServerPacket serverPacket = this;
                if (serverPacket instanceof Play) {
                    Play play = (Play)serverPacket;
                    n = play.playId();
                    break;
                }
                n = id = -1;
            }
        }
        if (id != -1) {
            return id;
        }
        ArrayList<ConnectionState> validStates = new ArrayList<ConnectionState>();
        if (this instanceof Configuration) {
            validStates.add(ConnectionState.CONFIGURATION);
        }
        if (this instanceof Status) {
            validStates.add(ConnectionState.STATUS);
        }
        if (this instanceof Login) {
            validStates.add(ConnectionState.LOGIN);
        }
        if (this instanceof Play) {
            validStates.add(ConnectionState.PLAY);
        }
        return PacketUtils.invalidPacketState(this.getClass(), state, (ConnectionState[])validStates.toArray(ConnectionState[]::new));
    }

    public static non-sealed interface Configuration
    extends ServerPacket {
        public int configurationId();
    }

    public static non-sealed interface Status
    extends ServerPacket {
        public int statusId();
    }

    public static non-sealed interface Login
    extends ServerPacket {
        public int loginId();
    }

    public static non-sealed interface Play
    extends ServerPacket {
        public int playId();
    }

    public static interface ComponentHolding
    extends ComponentHolder<ServerPacket> {
    }
}

