/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.minestom.server.adventure.serializer.nbt.NbtComponentSerializer;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.play.data.WorldPos;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.ProtocolObject;
import net.minestom.server.registry.Registries;
import net.minestom.server.utils.Unit;
import net.minestom.server.utils.nbt.BinaryTagReader;
import net.minestom.server.utils.nbt.BinaryTagWriter;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;

interface NetworkBufferTypeImpl<T>
extends NetworkBuffer.Type<T> {
    public static final int SEGMENT_BITS = 127;
    public static final int CONTINUE_BIT = 128;

    public record RegistryTypeType<T extends ProtocolObject>(@NotNull Function<Registries, DynamicRegistry<T>> selector) implements NetworkBufferTypeImpl<DynamicRegistry.Key<T>>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, DynamicRegistry.Key<T> value) {
            Check.stateCondition(buffer.registries == null, "Buffer does not have registries");
            DynamicRegistry<T> registry = this.selector.apply(buffer.registries);
            int id = registry.getId(value);
            Check.argCondition(id == -1, "Key is not registered: {0} > {1}", registry, value);
            buffer.write(NetworkBuffer.VAR_INT, id);
        }

        @Override
        public DynamicRegistry.Key<T> read(@NotNull NetworkBuffer buffer) {
            Check.stateCondition(buffer.registries == null, "Buffer does not have registries");
            DynamicRegistry<int> registry = this.selector.apply(buffer.registries);
            int id = buffer.read(NetworkBuffer.VAR_INT);
            DynamicRegistry.Key<int> key = registry.getKey(id);
            Check.argCondition(key == null, "No such ID in registry: {0} > {1}", registry, id);
            return key;
        }
    }

    public record ListType<T>(@NotNull NetworkBuffer.Type<T> parent, int maxSize) implements NetworkBufferTypeImpl<List<T>>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, List<T> value) {
            buffer.writeCollection(this.parent, value);
        }

        @Override
        public List<T> read(@NotNull NetworkBuffer buffer) {
            return buffer.readCollection(this.parent, this.maxSize);
        }
    }

    public record MappedType<T, S>(@NotNull NetworkBuffer.Type<T> parent, @NotNull Function<T, S> to, @NotNull Function<S, T> from) implements NetworkBufferTypeImpl<S>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, S value) {
            this.parent.write(buffer, this.from.apply(value));
        }

        @Override
        public S read(@NotNull NetworkBuffer buffer) {
            return this.to.apply(this.parent.read(buffer));
        }
    }

    public static final class LazyType<T>
    implements NetworkBufferTypeImpl<T> {
        @NotNull
        private final @NotNull Supplier<@NotNull NetworkBuffer.Type<T>> supplier;
        private NetworkBuffer.Type<T> type;

        public LazyType(@NotNull @NotNull Supplier<@NotNull NetworkBuffer.Type<T>> supplier) {
            this.supplier = supplier;
        }

        @Override
        public void write(@NotNull NetworkBuffer buffer, T value) {
            if (this.type == null) {
                this.type = this.supplier.get();
            }
            this.type.write(buffer, value);
        }

        @Override
        public T read(@NotNull NetworkBuffer buffer) {
            if (this.type == null) {
                this.type = this.supplier.get();
            }
            return null;
        }
    }

    public record OptionalType<T>(@NotNull NetworkBuffer.Type<T> parent) implements NetworkBufferTypeImpl<T>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, T value) {
            buffer.writeOptional(this.parent, value);
        }

        @Override
        public T read(@NotNull NetworkBuffer buffer) {
            return buffer.readOptional(this.parent);
        }
    }

    public record EnumType<E extends Enum<?>>(@NotNull Class<E> enumClass) implements NetworkBufferTypeImpl<E>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, E value) {
            buffer.writeEnum(this.enumClass, value);
        }

        @Override
        public E read(@NotNull NetworkBuffer buffer) {
            return buffer.readEnum(this.enumClass);
        }
    }

    public record QuaternionType() implements NetworkBufferTypeImpl<float[]>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, float[] value) {
            buffer.write(NetworkBuffer.FLOAT, Float.valueOf(value[0]));
            buffer.write(NetworkBuffer.FLOAT, Float.valueOf(value[1]));
            buffer.write(NetworkBuffer.FLOAT, Float.valueOf(value[2]));
            buffer.write(NetworkBuffer.FLOAT, Float.valueOf(value[3]));
        }

        @Override
        public float[] read(@NotNull NetworkBuffer buffer) {
            float x = buffer.read(NetworkBuffer.FLOAT).floatValue();
            float y = buffer.read(NetworkBuffer.FLOAT).floatValue();
            float z = buffer.read(NetworkBuffer.FLOAT).floatValue();
            float w = buffer.read(NetworkBuffer.FLOAT).floatValue();
            return new float[]{x, y, z, w};
        }
    }

    public record Vector3DType() implements NetworkBufferTypeImpl<Point>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Point value) {
            buffer.write(NetworkBuffer.DOUBLE, value.x());
            buffer.write(NetworkBuffer.DOUBLE, value.y());
            buffer.write(NetworkBuffer.DOUBLE, value.z());
        }

        @Override
        public Point read(@NotNull NetworkBuffer buffer) {
            double x = buffer.read(NetworkBuffer.DOUBLE);
            double y = buffer.read(NetworkBuffer.DOUBLE);
            double z = buffer.read(NetworkBuffer.DOUBLE);
            return new Vec(x, y, z);
        }
    }

    public record Vector3Type() implements NetworkBufferTypeImpl<Point>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Point value) {
            buffer.write(NetworkBuffer.FLOAT, Float.valueOf((float)value.x()));
            buffer.write(NetworkBuffer.FLOAT, Float.valueOf((float)value.y()));
            buffer.write(NetworkBuffer.FLOAT, Float.valueOf((float)value.z()));
        }

        @Override
        public Point read(@NotNull NetworkBuffer buffer) {
            float x = buffer.read(NetworkBuffer.FLOAT).floatValue();
            float y = buffer.read(NetworkBuffer.FLOAT).floatValue();
            float z = buffer.read(NetworkBuffer.FLOAT).floatValue();
            return new Vec(x, y, z);
        }
    }

    public record DeathLocationType() implements NetworkBufferTypeImpl<WorldPos>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, WorldPos value) {
            buffer.writeOptional(value);
        }

        @Override
        public WorldPos read(@NotNull NetworkBuffer buffer) {
            return buffer.readOptional(WorldPos::new);
        }
    }

    public record VillagerDataType() implements NetworkBufferTypeImpl<int[]>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, int[] value) {
            buffer.write(NetworkBuffer.VAR_INT, value[0]);
            buffer.write(NetworkBuffer.VAR_INT, value[1]);
            buffer.write(NetworkBuffer.VAR_INT, value[2]);
        }

        @Override
        public int[] read(@NotNull NetworkBuffer buffer) {
            int[] value = new int[]{buffer.read(NetworkBuffer.VAR_INT), buffer.read(NetworkBuffer.VAR_INT), buffer.read(NetworkBuffer.VAR_INT)};
            return value;
        }
    }

    public record BlockStateType() implements NetworkBufferTypeImpl<Integer>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Integer value) {
            buffer.write(NetworkBuffer.VAR_INT, value);
        }

        @Override
        public Integer read(@NotNull NetworkBuffer buffer) {
            return buffer.read(NetworkBuffer.VAR_INT);
        }
    }

    public record VarLongArrayType() implements NetworkBufferTypeImpl<long[]>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, long[] value) {
            buffer.write(NetworkBuffer.VAR_INT, value.length);
            for (long l : value) {
                buffer.write(NetworkBuffer.VAR_LONG, l);
            }
        }

        @Override
        public long[] read(@NotNull NetworkBuffer buffer) {
            int length = buffer.read(NetworkBuffer.VAR_INT);
            long[] longs = new long[length];
            for (int i = 0; i < length; ++i) {
                longs[i] = buffer.read(NetworkBuffer.VAR_LONG);
            }
            return longs;
        }
    }

    public record VarIntArrayType() implements NetworkBufferTypeImpl<int[]>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, int[] value) {
            buffer.write(NetworkBuffer.VAR_INT, value.length);
            for (int i : value) {
                buffer.write(NetworkBuffer.VAR_INT, i);
            }
        }

        @Override
        public int[] read(@NotNull NetworkBuffer buffer) {
            int length = buffer.read(NetworkBuffer.VAR_INT);
            int[] ints = new int[length];
            for (int i = 0; i < length; ++i) {
                ints[i] = buffer.read(NetworkBuffer.VAR_INT);
            }
            return ints;
        }
    }

    public record LongArrayType() implements NetworkBufferTypeImpl<long[]>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, long[] value) {
            buffer.write(NetworkBuffer.VAR_INT, value.length);
            for (long l : value) {
                buffer.write(NetworkBuffer.LONG, l);
            }
        }

        @Override
        public long[] read(@NotNull NetworkBuffer buffer) {
            int length = buffer.read(NetworkBuffer.VAR_INT);
            long[] longs = new long[length];
            for (int i = 0; i < length; ++i) {
                longs[i] = buffer.read(NetworkBuffer.LONG);
            }
            return longs;
        }
    }

    public record ByteArrayType() implements NetworkBufferTypeImpl<byte[]>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, byte[] value) {
            buffer.write(NetworkBuffer.VAR_INT, value.length);
            buffer.write(NetworkBuffer.RAW_BYTES, value);
        }

        @Override
        public byte[] read(@NotNull NetworkBuffer buffer) {
            int length = buffer.read(NetworkBuffer.VAR_INT);
            byte[] bytes = new byte[length];
            buffer.nioBuffer.get(buffer.readIndex(), bytes);
            buffer.readIndex += length;
            return bytes;
        }
    }

    public record UUIDType() implements NetworkBufferTypeImpl<UUID>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, UUID value) {
            buffer.write(NetworkBuffer.LONG, value.getMostSignificantBits());
            buffer.write(NetworkBuffer.LONG, value.getLeastSignificantBits());
        }

        @Override
        public UUID read(@NotNull NetworkBuffer buffer) {
            long mostSignificantBits = buffer.read(NetworkBuffer.LONG);
            long leastSignificantBits = buffer.read(NetworkBuffer.LONG);
            return new UUID(mostSignificantBits, leastSignificantBits);
        }
    }

    public record JsonComponentType() implements NetworkBufferTypeImpl<Component>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Component value) {
            String json = (String)GsonComponentSerializer.gson().serialize(value);
            buffer.write(NetworkBuffer.STRING, json);
        }

        @Override
        public Component read(@NotNull NetworkBuffer buffer) {
            String json = buffer.read(NetworkBuffer.STRING);
            return GsonComponentSerializer.gson().deserialize((Object)json);
        }
    }

    public record ComponentType() implements NetworkBufferTypeImpl<Component>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Component value) {
            BinaryTag nbt = (BinaryTag)NbtComponentSerializer.nbt().serialize(value);
            buffer.write(NetworkBuffer.NBT, nbt);
        }

        @Override
        public Component read(@NotNull NetworkBuffer buffer) {
            BinaryTag nbt = buffer.read(NetworkBuffer.NBT);
            return NbtComponentSerializer.nbt().deserialize(nbt);
        }
    }

    public record BlockPositionType() implements NetworkBufferTypeImpl<Point>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Point value) {
            int blockX = value.blockX();
            int blockY = value.blockY();
            int blockZ = value.blockZ();
            long longPos = ((long)blockX & 0x3FFFFFFL) << 38 | ((long)blockZ & 0x3FFFFFFL) << 12 | (long)blockY & 0xFFFL;
            buffer.write(NetworkBuffer.LONG, longPos);
        }

        @Override
        public Point read(@NotNull NetworkBuffer buffer) {
            long value = buffer.read(NetworkBuffer.LONG);
            int x = (int)(value >> 38);
            int y = (int)(value << 52 >> 52);
            int z = (int)(value << 26 >> 38);
            return new Vec(x, y, z);
        }
    }

    public record NbtType() implements NetworkBufferTypeImpl<BinaryTag>
    {
        @Override
        public void write(final @NotNull NetworkBuffer buffer, BinaryTag value) {
            BinaryTagWriter nbtWriter = buffer.nbtWriter;
            if (nbtWriter == null) {
                buffer.nbtWriter = nbtWriter = new BinaryTagWriter(new DataOutputStream(new OutputStream(this){

                    @Override
                    public void write(int b) {
                        buffer.write(NetworkBuffer.BYTE, (byte)b);
                    }
                }));
            }
            try {
                nbtWriter.writeNameless(value);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public BinaryTag read(final @NotNull NetworkBuffer buffer) {
            BinaryTagReader nbtReader = buffer.nbtReader;
            if (nbtReader == null) {
                buffer.nbtReader = nbtReader = new BinaryTagReader(new DataInputStream(new InputStream(this){

                    @Override
                    public int read() {
                        return buffer.read(NetworkBuffer.BYTE) & 0xFF;
                    }

                    @Override
                    public int available() {
                        return buffer.readableBytes();
                    }
                }));
            }
            try {
                return nbtReader.readNameless();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public record StringType() implements NetworkBufferTypeImpl<String>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, String value) {
            byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
            buffer.write(NetworkBuffer.VAR_INT, bytes.length);
            buffer.write(NetworkBuffer.RAW_BYTES, bytes);
        }

        @Override
        public String read(@NotNull NetworkBuffer buffer) {
            int remaining;
            int length = buffer.read(NetworkBuffer.VAR_INT);
            Check.argCondition(length > (remaining = buffer.nioBuffer.limit() - buffer.readIndex()), "String is too long (length: {0}, readable: {1})", length, remaining);
            byte[] bytes = new byte[length];
            buffer.nioBuffer.get(buffer.readIndex(), bytes);
            buffer.readIndex += length;
            return new String(bytes, StandardCharsets.UTF_8);
        }
    }

    public record RawBytesType() implements NetworkBufferTypeImpl<byte[]>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, byte[] value) {
            buffer.ensureSize(value.length);
            buffer.nioBuffer.put(buffer.writeIndex(), value);
            buffer.writeIndex += value.length;
        }

        @Override
        public byte[] read(@NotNull NetworkBuffer buffer) {
            int limit = buffer.nioBuffer.limit();
            int length = limit - buffer.readIndex();
            assert (length > 0) : "Invalid remaining: " + length;
            byte[] bytes = new byte[length];
            buffer.nioBuffer.get(buffer.readIndex(), bytes);
            buffer.readIndex += length;
            return bytes;
        }
    }

    public record VarLongType() implements NetworkBufferTypeImpl<Long>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Long value) {
            buffer.ensureSize(10);
            int size = 0;
            while (true) {
                if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    buffer.nioBuffer.put(buffer.writeIndex() + size, (byte)value.intValue());
                    buffer.writeIndex += size + 1;
                    return;
                }
                buffer.nioBuffer.put(buffer.writeIndex() + size, (byte)(value & 0x7FL | 0x80L));
                ++size;
                value = value >>> 7;
            }
        }

        @Override
        public Long read(@NotNull NetworkBuffer buffer) {
            long value;
            int length;
            block1: {
                length = 0;
                value = 0L;
                int position = 0;
                do {
                    byte currentByte = buffer.nioBuffer.get(buffer.readIndex() + length);
                    ++length;
                    value |= (long)(currentByte & 0x7F) << position;
                    if ((currentByte & 0x80) == 0) break block1;
                } while ((position += 7) < 64);
                throw new RuntimeException("VarLong is too big");
            }
            buffer.readIndex += length;
            return value;
        }
    }

    public record VarIntType() implements NetworkBufferTypeImpl<Integer>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Integer boxed) {
            int value = boxed;
            int index = buffer.writeIndex();
            if ((value & 0xFFFFFF80) == 0) {
                buffer.ensureSize(1);
                buffer.nioBuffer.put(index, (byte)value);
                ++buffer.writeIndex;
            } else if ((value & 0xFFFFC000) == 0) {
                buffer.ensureSize(2);
                buffer.nioBuffer.putShort(index, (short)((value & 0x7F | 0x80) << 8 | value >>> 7));
                buffer.writeIndex += 2;
            } else if ((value & 0xFFE00000) == 0) {
                buffer.ensureSize(3);
                ByteBuffer nio = buffer.nioBuffer;
                nio.put(index, (byte)(value & 0x7F | 0x80));
                nio.put(index + 1, (byte)(value >>> 7 & 0x7F | 0x80));
                nio.put(index + 2, (byte)(value >>> 14));
                buffer.writeIndex += 3;
            } else if ((value & 0xF0000000) == 0) {
                buffer.ensureSize(4);
                ByteBuffer nio = buffer.nioBuffer;
                nio.putInt(index, (value & 0x7F | 0x80) << 24 | (value >>> 7 & 0x7F | 0x80) << 16 | (value >>> 14 & 0x7F | 0x80) << 8 | value >>> 21);
                buffer.writeIndex += 4;
            } else {
                buffer.ensureSize(5);
                ByteBuffer nio = buffer.nioBuffer;
                nio.putInt(index, (value & 0x7F | 0x80) << 24 | (value >>> 7 & 0x7F | 0x80) << 16 | (value >>> 14 & 0x7F | 0x80) << 8 | (value >>> 21 & 0x7F | 0x80));
                nio.put(index + 4, (byte)(value >>> 28));
                buffer.writeIndex += 5;
            }
        }

        @Override
        public Integer read(@NotNull NetworkBuffer buffer) {
            int index = buffer.readIndex();
            int result = 0;
            int shift = 0;
            while (true) {
                byte b = buffer.nioBuffer.get(index++);
                result |= (b & 0x7F) << shift;
                if (b >= 0) {
                    buffer.readIndex += index - buffer.readIndex();
                    return result;
                }
                shift += 7;
            }
        }
    }

    public record DoubleType() implements NetworkBufferTypeImpl<Double>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Double value) {
            buffer.ensureSize(8);
            buffer.nioBuffer.putDouble(buffer.writeIndex(), value);
            buffer.writeIndex += 8;
        }

        @Override
        public Double read(@NotNull NetworkBuffer buffer) {
            double value = buffer.nioBuffer.getDouble(buffer.readIndex());
            buffer.readIndex += 8;
            return value;
        }
    }

    public record FloatType() implements NetworkBufferTypeImpl<Float>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Float value) {
            buffer.ensureSize(4);
            buffer.nioBuffer.putFloat(buffer.writeIndex(), value.floatValue());
            buffer.writeIndex += 4;
        }

        @Override
        public Float read(@NotNull NetworkBuffer buffer) {
            float value = buffer.nioBuffer.getFloat(buffer.readIndex());
            buffer.readIndex += 4;
            return Float.valueOf(value);
        }
    }

    public record LongType() implements NetworkBufferTypeImpl<Long>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Long value) {
            buffer.ensureSize(8);
            buffer.nioBuffer.putLong(buffer.writeIndex(), value);
            buffer.writeIndex += 8;
        }

        @Override
        public Long read(@NotNull NetworkBuffer buffer) {
            long value = buffer.nioBuffer.getLong(buffer.readIndex());
            buffer.readIndex += 8;
            return value;
        }
    }

    public record IntType() implements NetworkBufferTypeImpl<Integer>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Integer value) {
            buffer.ensureSize(4);
            buffer.nioBuffer.putInt(buffer.writeIndex(), value);
            buffer.writeIndex += 4;
        }

        @Override
        public Integer read(@NotNull NetworkBuffer buffer) {
            int value = buffer.nioBuffer.getInt(buffer.readIndex());
            buffer.readIndex += 4;
            return value;
        }
    }

    public record UnsignedShortType() implements NetworkBufferTypeImpl<Integer>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Integer value) {
            buffer.ensureSize(2);
            buffer.nioBuffer.putShort(buffer.writeIndex(), (short)(value & 0xFFFF));
            buffer.writeIndex += 2;
        }

        @Override
        public Integer read(@NotNull NetworkBuffer buffer) {
            short value = buffer.nioBuffer.getShort(buffer.readIndex());
            buffer.readIndex += 2;
            return value & 0xFFFF;
        }
    }

    public record ShortType() implements NetworkBufferTypeImpl<Short>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Short value) {
            buffer.ensureSize(2);
            buffer.nioBuffer.putShort(buffer.writeIndex(), value);
            buffer.writeIndex += 2;
        }

        @Override
        public Short read(@NotNull NetworkBuffer buffer) {
            short value = buffer.nioBuffer.getShort(buffer.readIndex());
            buffer.readIndex += 2;
            return value;
        }
    }

    public record ByteType() implements NetworkBufferTypeImpl<Byte>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Byte value) {
            buffer.ensureSize(1);
            buffer.nioBuffer.put(buffer.writeIndex(), value);
            ++buffer.writeIndex;
        }

        @Override
        public Byte read(@NotNull NetworkBuffer buffer) {
            byte value = buffer.nioBuffer.get(buffer.readIndex());
            ++buffer.readIndex;
            return value;
        }
    }

    public record BooleanType() implements NetworkBufferTypeImpl<Boolean>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Boolean value) {
            buffer.ensureSize(1);
            buffer.nioBuffer.put(buffer.writeIndex(), value != false ? (byte)1 : 0);
            ++buffer.writeIndex;
        }

        @Override
        public Boolean read(@NotNull NetworkBuffer buffer) {
            byte value = buffer.nioBuffer.get(buffer.readIndex());
            ++buffer.readIndex;
            return value == 1;
        }
    }

    public record UnitType() implements NetworkBufferTypeImpl<Unit>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Unit value) {
        }

        @Override
        public Unit read(@NotNull NetworkBuffer buffer) {
            return Unit.INSTANCE;
        }
    }
}

