/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.palette;

import java.util.function.IntUnaryOperator;
import net.minestom.server.instance.palette.AdaptivePalette;
import net.minestom.server.network.NetworkBuffer;
import org.jetbrains.annotations.NotNull;

public interface Palette
extends NetworkBuffer.Writer {
    public static Palette blocks() {
        return Palette.newPalette(16, 8, 4);
    }

    public static Palette biomes() {
        return Palette.newPalette(4, 3, 1);
    }

    public static Palette newPalette(int dimension, int maxBitsPerEntry, int bitsPerEntry) {
        return new AdaptivePalette((byte)dimension, (byte)maxBitsPerEntry, (byte)bitsPerEntry);
    }

    public int get(int var1, int var2, int var3);

    public void getAll(@NotNull EntryConsumer var1);

    public void getAllPresent(@NotNull EntryConsumer var1);

    public void set(int var1, int var2, int var3, int var4);

    public void fill(int var1);

    public void setAll(@NotNull EntrySupplier var1);

    public void replace(int var1, int var2, int var3, @NotNull IntUnaryOperator var4);

    public void replaceAll(@NotNull EntryFunction var1);

    public int count();

    public int bitsPerEntry();

    public int maxBitsPerEntry();

    public int dimension();

    default public int maxSize() {
        int dimension = this.dimension();
        return dimension * dimension * dimension;
    }

    @NotNull
    public Palette clone();

    @FunctionalInterface
    public static interface EntryFunction {
        public int apply(int var1, int var2, int var3, int var4);
    }

    @FunctionalInterface
    public static interface EntryConsumer {
        public void accept(int var1, int var2, int var3, int var4);
    }

    @FunctionalInterface
    public static interface EntrySupplier {
        public int get(int var1, int var2, int var3);
    }
}

