/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.minestom.server.MinecraftServer;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.NoopChunkLoaderImpl;
import net.minestom.server.utils.async.AsyncUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IChunkLoader {
    @NotNull
    public static IChunkLoader noop() {
        return NoopChunkLoaderImpl.INSTANCE;
    }

    default public void loadInstance(@NotNull Instance instance) {
    }

    public @NotNull CompletableFuture<@Nullable Chunk> loadChunk(@NotNull Instance var1, int var2, int var3);

    @NotNull
    default public CompletableFuture<Void> saveInstance(@NotNull Instance instance) {
        return AsyncUtils.VOID_FUTURE;
    }

    @NotNull
    public CompletableFuture<Void> saveChunk(@NotNull Chunk var1);

    @NotNull
    default public CompletableFuture<Void> saveChunks(@NotNull Collection<Chunk> chunks) {
        if (this.supportsParallelSaving()) {
            ForkJoinPool parallelSavingThreadPool = ForkJoinPool.commonPool();
            chunks.forEach(c -> parallelSavingThreadPool.execute(() -> this.saveChunk((Chunk)c)));
            try {
                parallelSavingThreadPool.shutdown();
                parallelSavingThreadPool.awaitTermination(1L, TimeUnit.DAYS);
            }
            catch (InterruptedException e) {
                MinecraftServer.getExceptionManager().handleException(e);
            }
            return AsyncUtils.VOID_FUTURE;
        }
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        AtomicInteger counter = new AtomicInteger();
        for (Chunk chunk : chunks) {
            this.saveChunk(chunk).whenComplete((unused, throwable) -> {
                boolean isLast;
                boolean bl = isLast = counter.incrementAndGet() == chunks.size();
                if (isLast) {
                    completableFuture.complete(null);
                }
            });
        }
        return completableFuture;
    }

    default public boolean supportsParallelSaving() {
        return false;
    }

    default public boolean supportsParallelLoading() {
        return false;
    }

    default public void unloadChunk(Chunk chunk) {
    }
}

