/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.snapshot;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import net.minestom.server.snapshot.Snapshot;
import net.minestom.server.snapshot.SnapshotUpdaterImpl;
import net.minestom.server.snapshot.Snapshotable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public sealed interface SnapshotUpdater
permits SnapshotUpdaterImpl {
    @NotNull
    public static <T extends Snapshot> T update(@NotNull Snapshotable snapshotable) {
        return SnapshotUpdaterImpl.update(snapshotable);
    }

    @NotNull
    public <T extends Snapshot> AtomicReference<T> reference(@NotNull Snapshotable var1);

    @Contract(value="!null -> !null")
    default public <T extends Snapshot> AtomicReference<T> optionalReference(Snapshotable snapshotable) {
        return snapshotable != null ? this.reference(snapshotable) : null;
    }

    @NotNull
    default public <T extends Snapshot, S extends Snapshotable, K> Map<K, AtomicReference<T>> referencesMap(@NotNull Collection<S> snapshotables, @NotNull Function<S, K> mappingFunction) {
        return snapshotables.stream().collect(Collectors.toUnmodifiableMap(mappingFunction, this::reference));
    }

    @NotNull
    default public <T extends Snapshot, S extends Snapshotable> Map<Long, AtomicReference<T>> referencesMapLong(@NotNull Collection<S> snapshotables, @NotNull ToLongFunction<S> mappingFunction) {
        Long2ObjectOpenHashMap map = new Long2ObjectOpenHashMap(snapshotables.size());
        for (Snapshotable snapshotable : snapshotables) {
            map.put(mappingFunction.applyAsLong(snapshotable), this.reference(snapshotable));
        }
        map.trim();
        return map;
    }

    @NotNull
    default public <T extends Snapshot, S extends Snapshotable> Map<Integer, AtomicReference<T>> referencesMapInt(@NotNull Collection<S> snapshotables, @NotNull ToIntFunction<S> mappingFunction) {
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap(snapshotables.size());
        for (Snapshotable snapshotable : snapshotables) {
            map.put(mappingFunction.applyAsInt(snapshotable), this.reference(snapshotable));
        }
        map.trim();
        return map;
    }
}

