/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.permission;

import java.util.Set;
import java.util.regex.Pattern;
import net.minestom.server.permission.Permission;
import net.minestom.server.permission.PermissionVerifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PermissionHandler {
    @NotNull
    public Set<Permission> getAllPermissions();

    default public void addPermission(@NotNull Permission permission) {
        this.getAllPermissions().add(permission);
    }

    default public void removePermission(@NotNull Permission permission) {
        this.getAllPermissions().remove(permission);
    }

    default public void removePermission(@NotNull String permissionName) {
        this.getAllPermissions().removeIf(permission -> permission.getPermissionName().equals(permissionName));
    }

    default public boolean hasPermission(@NotNull Permission permission) {
        for (Permission permissionLoop : this.getAllPermissions()) {
            if (permissionLoop.equals(permission)) {
                return true;
            }
            String permissionLoopName = permissionLoop.getPermissionName();
            if (!permissionLoopName.contains("*")) continue;
            String regexSanitized = Pattern.quote(permissionLoopName).replace("*", "\\E(.*)\\Q");
            if (!permission.getPermissionName().matches(regexSanitized)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    default public Permission getPermission(@NotNull String permissionName) {
        for (Permission permission : this.getAllPermissions()) {
            if (!permission.getPermissionName().equals(permissionName)) continue;
            return permission;
        }
        return null;
    }

    default public boolean hasPermission(@NotNull String permissionName, @Nullable PermissionVerifier permissionVerifier) {
        Permission permission = this.getPermission(permissionName);
        if (permission == null && permissionVerifier == null) {
            permission = new Permission(permissionName, null);
        } else if (permission == null) {
            return false;
        }
        if (permissionVerifier == null) {
            return this.hasPermission(permission);
        }
        return permissionVerifier.isValid(permission.getNBTData());
    }

    default public boolean hasPermission(@NotNull String permissionName) {
        return this.hasPermission(permissionName, null);
    }
}

