/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.pathfinding;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.pathfinding.PNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PPath {
    private final Runnable onComplete;
    private final List<PNode> nodes = new ArrayList<PNode>();
    private final double pathVariance;
    private final double maxDistance;
    private int index = 0;
    private final AtomicReference<PathState> state = new AtomicReference<PathState>(PathState.CALCULATING);

    public Point getNext() {
        if (this.index + 1 >= this.nodes.size()) {
            return null;
        }
        PNode current = this.nodes.get(this.index + 1);
        return new Vec(current.x(), current.y(), current.z());
    }

    public void setState(@NotNull PathState newState) {
        this.state.set(newState);
    }

    @NotNull
    PathState getState() {
        return this.state.get();
    }

    @NotNull
    public List<PNode> getNodes() {
        return this.nodes;
    }

    public PPath(double maxDistance, double pathVariance, Runnable onComplete) {
        this.onComplete = onComplete;
        this.maxDistance = maxDistance;
        this.pathVariance = pathVariance;
    }

    void runComplete() {
        if (this.onComplete != null) {
            this.onComplete.run();
        }
    }

    @NotNull
    public String toString() {
        return this.nodes.toString();
    }

    @Nullable
    PNode.NodeType getCurrentType() {
        if (this.index >= this.nodes.size()) {
            return null;
        }
        PNode current = this.nodes.get(this.index);
        return current.getType();
    }

    @Nullable
    Point getCurrent() {
        if (this.index >= this.nodes.size()) {
            return null;
        }
        PNode current = this.nodes.get(this.index);
        return new Vec(current.x(), current.y(), current.z());
    }

    void next() {
        if (this.index >= this.nodes.size()) {
            return;
        }
        ++this.index;
    }

    double maxDistance() {
        return this.maxDistance;
    }

    double pathVariance() {
        return this.pathVariance;
    }

    public static enum PathState {
        CALCULATING,
        FOLLOWING,
        TERMINATING,
        TERMINATED,
        COMPUTED,
        BEST_EFFORT,
        INVALID;

    }
}

