/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.command.builder.arguments;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.UnaryOperator;
import net.minestom.server.command.CommandSender;
import net.minestom.server.command.builder.arguments.Argument;
import net.minestom.server.command.builder.exception.ArgumentSyntaxException;
import org.jetbrains.annotations.NotNull;

public class ArgumentEnum<E extends Enum>
extends Argument<E> {
    public static final int NOT_ENUM_VALUE_ERROR = 1;
    private final Class<E> enumClass;
    private final E[] values;
    private Format format = Format.DEFAULT;

    public ArgumentEnum(@NotNull String id, Class<E> enumClass) {
        super(id);
        this.enumClass = enumClass;
        this.values = (Enum[])enumClass.getEnumConstants();
    }

    public ArgumentEnum<E> setFormat(@NotNull Format format) {
        this.format = format;
        return this;
    }

    @Override
    @NotNull
    public E parse(@NotNull CommandSender sender, @NotNull String input) throws ArgumentSyntaxException {
        for (E value : this.values) {
            if (!((String)this.format.formatter.apply(((Enum)value).name())).equals(input)) continue;
            return value;
        }
        throw new ArgumentSyntaxException("Not a " + this.enumClass.getSimpleName() + " value", input, 1);
    }

    @Override
    public String parser() {
        return null;
    }

    public List<String> entries() {
        return Arrays.stream(this.values).map((? super T x) -> (String)this.format.formatter.apply(x.name())).toList();
    }

    public String toString() {
        return String.format("Enum<%s>", this.getId());
    }

    public static enum Format {
        DEFAULT(name -> name),
        LOWER_CASED(name -> name.toLowerCase(Locale.ROOT)),
        UPPER_CASED(name -> name.toUpperCase(Locale.ROOT));

        private final UnaryOperator<String> formatter;

        private Format(UnaryOperator<String> formatter) {
            this.formatter = formatter;
        }
    }
}

