package net.minestom.server.network.packet.server.play;

import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import org.jetbrains.annotations.NotNull;

import static net.minestom.server.network.NetworkBuffer.BYTE;

public record HeldItemChangePacket(byte slot) implements ServerPacket.Play {
    public HeldItemChangePacket(@NotNull NetworkBuffer reader) {
        this(reader.read(BYTE));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(BYTE, slot);
    }

    @Override
    public int playId() {
        return ServerPacketIdentifier.HELD_ITEM_CHANGE;
    }
}
