/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.world;

import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.ProtocolObject;
import net.minestom.server.registry.Registry;
import net.minestom.server.world.DimensionTypeImpl;
import net.minestom.server.world.DimensionTypes;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface DimensionType
extends ProtocolObject,
DimensionTypes
permits DimensionTypeImpl {
    public static final int VANILLA_MIN_Y = -64;
    public static final int VANILLA_MAX_Y = 319;

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @ApiStatus.Internal
    @NotNull
    public static DynamicRegistry<DimensionType> createDefaultRegistry() {
        return DynamicRegistry.create("minecraft:dimension_type", DimensionTypeImpl.REGISTRY_NBT_TYPE, Registry.Resource.DIMENSION_TYPES, (namespace, props) -> new DimensionTypeImpl(Registry.dimensionType(namespace, props)));
    }

    public boolean ultrawarm();

    public boolean natural();

    public double coordinateScale();

    public boolean hasSkylight();

    public boolean hasCeiling();

    public float ambientLight();

    @Nullable
    public Long fixedTime();

    public boolean piglinSafe();

    public boolean bedWorks();

    public boolean respawnAnchorWorks();

    public boolean hasRaids();

    public int logicalHeight();

    public int minY();

    default public int maxY() {
        return this.minY() + this.height();
    }

    public int height();

    @NotNull
    public String infiniburn();

    @NotNull
    public String effects();

    default public int totalHeight() {
        return this.minY() + this.height();
    }

    public static final class Builder {
        private boolean ultrawarm = false;
        private boolean natural = true;
        private double coordinateScale = 1.0;
        private boolean hasSkylight = true;
        private boolean hasCeiling = false;
        private float ambientLight = 0.0f;
        private Long fixedTime = null;
        private boolean piglinSafe = false;
        private boolean bedWorks = true;
        private boolean respawnAnchorWorks = false;
        private boolean hasRaids = true;
        private int logicalHeight = 384;
        private int minY = -64;
        private int height = 384;
        private String infiniburn = "#minecraft:infiniburn_overworld";
        private String effects = "minecraft:overworld";

        private Builder() {
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder ultrawarm(boolean ultrawarm) {
            this.ultrawarm = ultrawarm;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder natural(boolean natural) {
            this.natural = natural;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder coordinateScale(double coordinateScale) {
            this.coordinateScale = coordinateScale;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder hasSkylight(boolean hasSkylight) {
            this.hasSkylight = hasSkylight;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder hasCeiling(boolean hasCeiling) {
            this.hasCeiling = hasCeiling;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder ambientLight(float ambientLight) {
            this.ambientLight = ambientLight;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder fixedTime(@Nullable Long fixedTime) {
            this.fixedTime = fixedTime;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder piglinSafe(boolean piglinSafe) {
            this.piglinSafe = piglinSafe;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder bedWorks(boolean bedWorks) {
            this.bedWorks = bedWorks;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder respawnAnchorWorks(boolean respawnAnchorWorks) {
            this.respawnAnchorWorks = respawnAnchorWorks;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder hasRaids(boolean hasRaids) {
            this.hasRaids = hasRaids;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder logicalHeight(int logicalHeight) {
            this.logicalHeight = logicalHeight;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder minY(int minY) {
            this.minY = minY;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder height(int height) {
            this.height = height;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder infiniburn(@NotNull String infiniburn) {
            this.infiniburn = infiniburn;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder effects(@NotNull String effects) {
            this.effects = effects;
            return this;
        }

        @Contract(pure=true)
        @NotNull
        public DimensionType build() {
            return new DimensionTypeImpl(this.ultrawarm, this.natural, this.coordinateScale, this.hasSkylight, this.hasCeiling, this.ambientLight, this.fixedTime, this.piglinSafe, this.bedWorks, this.respawnAnchorWorks, this.hasRaids, this.logicalHeight, this.minY, this.height, this.infiniburn, this.effects, null);
        }
    }
}

