/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.minestom.server.crypto.ChatSession;
import net.minestom.server.entity.GameMode;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PlayerInfoUpdatePacket
implements ServerPacket.Play {
    public static final int MAX_ENTRIES = 1024;
    @NotNull
    private final @NotNull EnumSet<@NotNull Action> actions;
    @NotNull
    private final @NotNull List<@NotNull Entry> entries;

    public PlayerInfoUpdatePacket(@NotNull @NotNull EnumSet<@NotNull Action> actions, @NotNull @NotNull List<@NotNull Entry> entries) {
        this.actions = EnumSet.copyOf(actions);
        this.entries = List.copyOf(entries);
    }

    public PlayerInfoUpdatePacket(@NotNull Action action, @NotNull Entry entry) {
        this.actions = EnumSet.of(action);
        this.entries = List.of(entry);
    }

    public PlayerInfoUpdatePacket(@NotNull NetworkBuffer reader) {
        this.actions = reader.readEnumSet(Action.class);
        this.entries = reader.readCollection(buffer -> {
            UUID uuid = buffer.read(NetworkBuffer.UUID);
            String username = "";
            List<Property> properties = List.of();
            boolean listed = false;
            int latency = 0;
            GameMode gameMode = GameMode.SURVIVAL;
            Component displayName = null;
            ChatSession chatSession = null;
            for (Action action : this.actions) {
                switch (action.ordinal()) {
                    case 0: {
                        username = reader.read(NetworkBuffer.STRING);
                        properties = reader.readCollection(Property::new, 1024);
                        break;
                    }
                    case 1: {
                        chatSession = new ChatSession(reader);
                        break;
                    }
                    case 2: {
                        gameMode = reader.readEnum(GameMode.class);
                        break;
                    }
                    case 3: {
                        listed = reader.read(NetworkBuffer.BOOLEAN);
                        break;
                    }
                    case 4: {
                        latency = reader.read(NetworkBuffer.VAR_INT);
                        break;
                    }
                    case 5: {
                        displayName = reader.readOptional(NetworkBuffer.COMPONENT);
                    }
                }
            }
            return new Entry(uuid, username, properties, listed, latency, gameMode, displayName, chatSession);
        }, 1024);
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.writeEnumSet(this.actions, Action.class);
        writer.writeCollection(this.entries, (buffer, entry) -> {
            buffer.write(NetworkBuffer.UUID, entry.uuid);
            for (Action action : this.actions) {
                action.writer.write((NetworkBuffer)buffer, (Entry)entry);
            }
        });
    }

    @Override
    public int playId() {
        return ServerPacketIdentifier.PLAYER_INFO_UPDATE;
    }

    @NotNull
    public EnumSet<Action> actions() {
        return this.actions;
    }

    @NotNull
    public List<Entry> entries() {
        return this.entries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlayerInfoUpdatePacket that = (PlayerInfoUpdatePacket)o;
        return this.actions.equals(that.actions) && this.entries.equals(that.entries);
    }

    public int hashCode() {
        return Objects.hash(this.actions, this.entries);
    }

    public String toString() {
        return "PlayerInfoUpdatePacket{actions=" + String.valueOf(this.actions) + ", entries=" + String.valueOf(this.entries) + "}";
    }

    public static enum Action {
        ADD_PLAYER((writer, entry) -> {
            writer.write(NetworkBuffer.STRING, entry.username);
            writer.writeCollection(entry.properties);
        }),
        INITIALIZE_CHAT((writer, entry) -> writer.writeOptional(entry.chatSession)),
        UPDATE_GAME_MODE((writer, entry) -> writer.write(NetworkBuffer.VAR_INT, entry.gameMode.ordinal())),
        UPDATE_LISTED((writer, entry) -> writer.write(NetworkBuffer.BOOLEAN, entry.listed)),
        UPDATE_LATENCY((writer, entry) -> writer.write(NetworkBuffer.VAR_INT, entry.latency)),
        UPDATE_DISPLAY_NAME((writer, entry) -> writer.writeOptional(NetworkBuffer.COMPONENT, entry.displayName));

        final Writer writer;

        private Action(Writer writer) {
            this.writer = writer;
        }

        static interface Writer {
            public void write(NetworkBuffer var1, Entry var2);
        }
    }

    public record Entry(UUID uuid, String username, List<Property> properties, boolean listed, int latency, GameMode gameMode, @Nullable Component displayName, @Nullable ChatSession chatSession) {
        public Entry(UUID uuid, String username, List<Property> properties, boolean listed, int latency, GameMode gameMode, @Nullable Component displayName, @Nullable ChatSession chatSession) {
            properties = List.copyOf(properties);
        }
    }

    public record Property(@NotNull String name, @NotNull String value, @Nullable String signature) implements NetworkBuffer.Writer
    {
        public Property(@NotNull String name, @NotNull String value) {
            this(name, value, null);
        }

        public Property(@NotNull NetworkBuffer reader) {
            this(reader.read(NetworkBuffer.STRING), reader.read(NetworkBuffer.STRING), reader.readOptional(NetworkBuffer.STRING));
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.STRING, this.name);
            writer.write(NetworkBuffer.STRING, this.value);
            writer.writeOptional(NetworkBuffer.STRING, this.signature);
        }
    }
}

