/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import net.kyori.adventure.sound.Sound;
import net.minestom.server.adventure.AdventurePacketConvertor;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.sound.SoundEvent;
import org.jetbrains.annotations.NotNull;

public record EntitySoundEffectPacket(@NotNull SoundEvent soundEvent, @NotNull Sound.Source source, int entityId, float volume, float pitch, long seed) implements ServerPacket.Play
{
    public EntitySoundEffectPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(SoundEvent.NETWORK_TYPE), reader.readEnum(Sound.Source.class), reader.read(NetworkBuffer.VAR_INT), reader.read(NetworkBuffer.FLOAT).floatValue(), reader.read(NetworkBuffer.FLOAT).floatValue(), reader.read(NetworkBuffer.LONG));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(SoundEvent.NETWORK_TYPE, this.soundEvent);
        writer.write(NetworkBuffer.VAR_INT, AdventurePacketConvertor.getSoundSourceValue(this.source));
        writer.write(NetworkBuffer.VAR_INT, this.entityId);
        writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.volume));
        writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.pitch));
        writer.write(NetworkBuffer.LONG, this.seed);
    }

    @Override
    public int playId() {
        return ServerPacketIdentifier.ENTITY_SOUND_EFFECT;
    }
}

