/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import net.minestom.server.coordinate.Pos;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import org.jetbrains.annotations.NotNull;

public record EntityPositionAndRotationPacket(int entityId, short deltaX, short deltaY, short deltaZ, float yaw, float pitch, boolean onGround) implements ServerPacket.Play
{
    public EntityPositionAndRotationPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.VAR_INT), reader.read(NetworkBuffer.SHORT), reader.read(NetworkBuffer.SHORT), reader.read(NetworkBuffer.SHORT), (float)reader.read(NetworkBuffer.BYTE).byteValue() * 360.0f / 256.0f, (float)reader.read(NetworkBuffer.BYTE).byteValue() * 360.0f / 256.0f, reader.read(NetworkBuffer.BOOLEAN));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.VAR_INT, this.entityId);
        writer.write(NetworkBuffer.SHORT, this.deltaX);
        writer.write(NetworkBuffer.SHORT, this.deltaY);
        writer.write(NetworkBuffer.SHORT, this.deltaZ);
        writer.write(NetworkBuffer.BYTE, (byte)(this.yaw * 256.0f / 360.0f));
        writer.write(NetworkBuffer.BYTE, (byte)(this.pitch * 256.0f / 360.0f));
        writer.write(NetworkBuffer.BOOLEAN, this.onGround);
    }

    @Override
    public int playId() {
        return ServerPacketIdentifier.ENTITY_POSITION_AND_ROTATION;
    }

    public static EntityPositionAndRotationPacket getPacket(int entityId, @NotNull Pos newPosition, @NotNull Pos oldPosition, boolean onGround) {
        short deltaX = (short)((newPosition.x() * 32.0 - oldPosition.x() * 32.0) * 128.0);
        short deltaY = (short)((newPosition.y() * 32.0 - oldPosition.y() * 32.0) * 128.0);
        short deltaZ = (short)((newPosition.z() * 32.0 - oldPosition.z() * 32.0) * 128.0);
        return new EntityPositionAndRotationPacket(entityId, deltaX, deltaY, deltaZ, newPosition.yaw(), newPosition.pitch(), onGround);
    }
}

