/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.List;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import org.jetbrains.annotations.NotNull;

public record DestroyEntitiesPacket(@NotNull List<Integer> entityIds) implements ServerPacket.Play
{
    public static final int MAX_ENTRIES = Short.MAX_VALUE;

    public DestroyEntitiesPacket(@NotNull List<Integer> entityIds) {
        entityIds = List.copyOf(entityIds);
    }

    public DestroyEntitiesPacket(int entityId) {
        this(List.of(Integer.valueOf(entityId)));
    }

    public DestroyEntitiesPacket(@NotNull NetworkBuffer reader) {
        this(reader.readCollection(NetworkBuffer.VAR_INT, Short.MAX_VALUE));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.writeCollection(NetworkBuffer.VAR_INT, this.entityIds);
    }

    @Override
    public int playId() {
        return ServerPacketIdentifier.DESTROY_ENTITIES;
    }
}

