/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.configuration;

import java.util.Set;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.utils.NamespaceID;
import org.jetbrains.annotations.NotNull;

public record UpdateEnabledFeaturesPacket(@NotNull Set<NamespaceID> features) implements ServerPacket.Configuration
{
    public static final int MAX_FEATURES = 1024;

    public UpdateEnabledFeaturesPacket(@NotNull NetworkBuffer buffer) {
        this(Set.copyOf(buffer.readCollection(b -> NamespaceID.from(b.read(NetworkBuffer.STRING)), 1024)));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.writeCollection(this.features, (b, feature) -> b.write(NetworkBuffer.STRING, feature.asString()));
    }

    @Override
    public int configurationId() {
        return ServerPacketIdentifier.CONFIGURATION_UPDATE_ENABLED_FEATURES;
    }
}

