/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.common;

import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.utils.NamespaceID;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;

public record CookieStorePacket(@NotNull String key, byte[] value) implements ServerPacket.Configuration,
ServerPacket.Play
{
    public static final int MAX_VALUE_LENGTH = 5120;

    public CookieStorePacket(@NotNull String key, byte[] value) {
        Check.argCondition(value.length > 5120, "Cookie value length too long: {0} > {1}", value.length, 5120);
    }

    public CookieStorePacket(@NotNull NamespaceID key, byte[] value) {
        this(key.asString(), value);
    }

    public CookieStorePacket(@NotNull NetworkBuffer reader) {
        this(CookieStorePacket.read(reader));
    }

    private CookieStorePacket(@NotNull CookieStorePacket other) {
        this(other.key, other.value);
    }

    @NotNull
    private static CookieStorePacket read(@NotNull NetworkBuffer reader) {
        String key = reader.read(NetworkBuffer.STRING);
        int valueLength = reader.read(NetworkBuffer.VAR_INT);
        Check.argCondition(valueLength > 5120, "Cookie value length too long: {0} > {1}", valueLength, 5120);
        byte[] value = reader.readBytes(valueLength);
        return new CookieStorePacket(key, value);
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.STRING, this.key);
        writer.write(NetworkBuffer.BYTE_ARRAY, this.value);
    }

    @Override
    public int configurationId() {
        return ServerPacketIdentifier.CONFIGURATION_COOKIE_STORE;
    }

    @Override
    public int playId() {
        return ServerPacketIdentifier.COOKIE_STORE;
    }
}

