/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.water;

import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Metadata;
import net.minestom.server.entity.MetadataHolder;
import net.minestom.server.entity.metadata.animal.AnimalMeta;
import org.jetbrains.annotations.NotNull;

public class AxolotlMeta
extends AnimalMeta {
    public static final byte OFFSET = 17;
    public static final byte MAX_OFFSET = 20;

    public AxolotlMeta(@NotNull Entity entity, @NotNull MetadataHolder metadata) {
        super(entity, metadata);
    }

    public Variant getVariant() {
        return Variant.VALUES[this.metadata.getIndex(17, 0)];
    }

    public void setVariant(Variant variant) {
        this.metadata.setIndex(17, Metadata.VarInt(variant.ordinal()));
    }

    public boolean isPlayingDead() {
        return this.metadata.getIndex(18, false);
    }

    public void setPlayingDead(boolean playingDead) {
        this.metadata.setIndex(18, Metadata.Boolean(playingDead));
    }

    public boolean isFromBucket() {
        return this.metadata.getIndex(19, false);
    }

    public void setFromBucket(boolean fromBucket) {
        this.metadata.setIndex(19, Metadata.Boolean(fromBucket));
    }

    public static enum Variant {
        LUCY,
        WILD,
        GOLD,
        CYAN,
        BLUE;

        private static final Variant[] VALUES;

        static {
            VALUES = Variant.values();
        }
    }
}

