/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.monster.zombie;

import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Metadata;
import net.minestom.server.entity.MetadataHolder;
import net.minestom.server.entity.metadata.monster.zombie.ZombieMeta;
import net.minestom.server.entity.metadata.villager.VillagerMeta;
import org.jetbrains.annotations.NotNull;

public class ZombieVillagerMeta
extends ZombieMeta {
    public static final byte OFFSET = 19;
    public static final byte MAX_OFFSET = 21;

    public ZombieVillagerMeta(@NotNull Entity entity, @NotNull MetadataHolder metadata) {
        super(entity, metadata);
    }

    public boolean isConverting() {
        return this.metadata.getIndex(19, false);
    }

    public void setConverting(boolean value) {
        this.metadata.setIndex(19, Metadata.Boolean(value));
    }

    public VillagerMeta.VillagerData getVillagerData() {
        int[] data = this.metadata.getIndex(20, null);
        if (data == null) {
            return new VillagerMeta.VillagerData(VillagerMeta.Type.PLAINS, VillagerMeta.Profession.NONE, VillagerMeta.Level.NOVICE);
        }
        return new VillagerMeta.VillagerData(VillagerMeta.Type.VALUES[data[0]], VillagerMeta.Profession.VALUES[data[1]], VillagerMeta.Level.VALUES[data[2] - 1]);
    }

    public void setVillagerData(VillagerMeta.VillagerData data) {
        this.metadata.setIndex(20, Metadata.VillagerData(data.getType().ordinal(), data.getProfession().ordinal(), data.getLevel().ordinal() + 1));
    }
}

