/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.crypto;

import net.minestom.server.network.NetworkBuffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnknownNullability;

public record MessageSignature(byte @NotNull [] signature) implements NetworkBuffer.Writer
{
    static final int SIGNATURE_BYTE_LENGTH = 256;

    public MessageSignature {
        if (signature.length != 256) {
            throw new IllegalArgumentException("Signature must be 256 bytes long");
        }
    }

    public MessageSignature(@NotNull NetworkBuffer reader) {
        this(reader.readBytes(256));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.RAW_BYTES, this.signature);
    }

    public record Packed(int id, @UnknownNullability MessageSignature fullSignature) implements NetworkBuffer.Writer
    {
        public Packed(@NotNull NetworkBuffer reader) {
            this(Packed.read(reader));
        }

        private Packed(@NotNull Packed packed) {
            this(packed.id, packed.fullSignature);
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.VAR_INT, this.id + 1);
            if (this.id == 0) {
                writer.write(this.fullSignature);
            }
        }

        private static Packed read(NetworkBuffer reader) {
            int id;
            return new Packed(id, (id = reader.read(NetworkBuffer.VAR_INT) - 1) == -1 ? new MessageSignature(reader) : null);
        }
    }
}

