/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.component;

import net.kyori.adventure.nbt.BinaryTag;
import net.minestom.server.component.DataComponentImpl;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.StaticProtocolObject;
import net.minestom.server.utils.NamespaceID;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface DataComponent<T>
extends StaticProtocolObject
permits DataComponentImpl {
    public boolean isSynced();

    public boolean isSerialized();

    @NotNull
    public T read(@NotNull BinaryTagSerializer.Context var1, @NotNull BinaryTag var2);

    @NotNull
    public BinaryTag write(@NotNull BinaryTagSerializer.Context var1, @NotNull T var2);

    @NotNull
    public T read(@NotNull NetworkBuffer var1);

    public void write(@NotNull NetworkBuffer var1, @NotNull T var2);

    @ApiStatus.Internal
    public static <T> DataComponent<T> createHeadless(int id, @NotNull NamespaceID namespace, @Nullable NetworkBuffer.Type<T> network, @Nullable BinaryTagSerializer<T> nbt) {
        return new DataComponentImpl<T>(id, namespace, network, nbt);
    }

    public static interface Holder {
        public boolean has(@NotNull DataComponent<?> var1);

        @Nullable
        public <T> T get(@NotNull DataComponent<T> var1);

        @NotNull
        default public <T> T get(@NotNull DataComponent<T> component, @NotNull T defaultValue) {
            T value = this.get(component);
            return value != null ? value : defaultValue;
        }
    }
}

