/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.command.builder.arguments;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minestom.server.command.CommandSender;
import net.minestom.server.command.builder.ArgumentCallback;
import net.minestom.server.command.builder.arguments.minecraft.SuggestionType;
import net.minestom.server.command.builder.exception.ArgumentSyntaxException;
import net.minestom.server.command.builder.suggestion.SuggestionCallback;
import net.minestom.server.registry.Registry;
import net.minestom.server.registry.StaticProtocolObject;
import net.minestom.server.utils.NamespaceID;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Argument<T> {
    @ApiStatus.Internal
    public static final Registry.Container<ArgumentImpl> CONTAINER = Registry.createStaticContainer(Registry.Resource.COMMAND_ARGUMENTS, (namespace, properties) -> new ArgumentImpl(NamespaceID.from(namespace), properties.getInt("id")));
    private final String id;
    protected final boolean allowSpace;
    protected final boolean useRemaining;
    private ArgumentCallback callback;
    private Function<CommandSender, T> defaultValue;
    private SuggestionCallback suggestionCallback;
    protected SuggestionType suggestionType;

    public Argument(@NotNull String id, boolean allowSpace, boolean useRemaining) {
        this.id = id;
        this.allowSpace = allowSpace;
        this.useRemaining = useRemaining;
    }

    public Argument(@NotNull String id, boolean allowSpace) {
        this(id, allowSpace, false);
    }

    public Argument(@NotNull String id) {
        this(id, false, false);
    }

    @NotNull
    public static <T> T parse(@NotNull CommandSender sender, @NotNull Argument<T> argument) throws ArgumentSyntaxException {
        return argument.parse(sender, argument.getId());
    }

    @NotNull
    public abstract T parse(@NotNull CommandSender var1, @NotNull String var2) throws ArgumentSyntaxException;

    public abstract String parser();

    public byte @Nullable [] nodeProperties() {
        return null;
    }

    @Nullable
    public SuggestionType suggestionType() {
        return this.suggestionType;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    public boolean allowSpace() {
        return this.allowSpace;
    }

    public boolean useRemaining() {
        return this.useRemaining;
    }

    @Nullable
    public ArgumentCallback getCallback() {
        return this.callback;
    }

    public void setCallback(@Nullable ArgumentCallback callback) {
        this.callback = callback;
    }

    public boolean hasErrorCallback() {
        return this.callback != null;
    }

    public boolean isOptional() {
        return this.defaultValue != null;
    }

    @Nullable
    public Function<CommandSender, T> getDefaultValue() {
        return this.defaultValue;
    }

    @NotNull
    public Argument<T> setDefaultValue(@Nullable Supplier<T> defaultValue) {
        this.defaultValue = unused -> defaultValue.get();
        return this;
    }

    @NotNull
    public Argument<T> setDefaultValue(@Nullable Function<CommandSender, T> defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    @NotNull
    public Argument<T> setDefaultValue(@NotNull T defaultValue) {
        this.defaultValue = unused -> defaultValue;
        return this;
    }

    @Nullable
    public SuggestionCallback getSuggestionCallback() {
        return this.suggestionCallback;
    }

    public Argument<T> setSuggestionCallback(@NotNull SuggestionCallback suggestionCallback) {
        this.suggestionCallback = suggestionCallback;
        this.suggestionType = SuggestionType.ASK_SERVER;
        return this;
    }

    public boolean hasSuggestion() {
        return this.suggestionType != null;
    }

    @NotNull
    public <O> Argument<O> map(@NotNull Function<T, O> mapper) {
        return new ArgumentMap<Object, Object>(this, (p, i) -> mapper.apply(i));
    }

    @NotNull
    public <O> Argument<O> map(@NotNull BiFunction<CommandSender, T, O> mapper) {
        return new ArgumentMap<T, O>(this, mapper);
    }

    @ApiStatus.Experimental
    @NotNull
    public Argument<T> filter(@NotNull Predicate<T> predicate) {
        return new ArgumentFilter<T>(this, predicate);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Argument argument = (Argument)o;
        return this.id.equals(argument.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    private static final class ArgumentMap<I, O>
    extends Argument<O> {
        public static final int INVALID_MAP = 555;
        final Argument<I> argument;
        final BiFunction<@NotNull CommandSender, I, O> mapper;

        private ArgumentMap(@NotNull Argument<I> argument, @NotNull @NotNull BiFunction<@NotNull CommandSender, I, O> mapper) {
            super(argument.getId(), argument.allowSpace(), argument.useRemaining());
            if (argument.getSuggestionCallback() != null) {
                this.setSuggestionCallback(argument.getSuggestionCallback());
            }
            if (argument.getDefaultValue() != null) {
                this.setDefaultValue(sender -> mapper.apply((CommandSender)sender, (Object)argument.getDefaultValue().apply((CommandSender)sender)));
            }
            this.argument = argument;
            this.mapper = mapper;
        }

        @Override
        @NotNull
        public O parse(@NotNull CommandSender sender, @NotNull String input) throws ArgumentSyntaxException {
            I value = this.argument.parse(sender, input);
            O mappedValue = this.mapper.apply(sender, value);
            if (mappedValue == null) {
                throw new ArgumentSyntaxException("Couldn't be converted to map type", input, 555);
            }
            return mappedValue;
        }

        @Override
        public String parser() {
            return this.argument.parser();
        }

        @Override
        public byte @Nullable [] nodeProperties() {
            return this.argument.nodeProperties();
        }
    }

    private static final class ArgumentFilter<T>
    extends Argument<T> {
        public static final int INVALID_FILTER = 556;
        final Argument<T> argument;
        final Predicate<T> predicate;

        private ArgumentFilter(@NotNull Argument<T> argument, @NotNull Predicate<T> predicate) {
            super(argument.getId(), argument.allowSpace(), argument.useRemaining());
            if (argument.getSuggestionCallback() != null) {
                this.setSuggestionCallback(argument.getSuggestionCallback());
            }
            if (argument.getDefaultValue() != null) {
                this.setDefaultValue(argument.getDefaultValue());
            }
            this.argument = argument;
            this.predicate = predicate;
        }

        @Override
        @NotNull
        public T parse(@NotNull CommandSender sender, @NotNull String input) throws ArgumentSyntaxException {
            T result = this.argument.parse(sender, input);
            if (!this.predicate.test(result)) {
                throw new ArgumentSyntaxException("Predicate failed", input, 556);
            }
            return result;
        }

        @Override
        public String parser() {
            return this.argument.parser();
        }

        @Override
        public byte @Nullable [] nodeProperties() {
            return this.argument.nodeProperties();
        }
    }

    record ArgumentImpl(NamespaceID namespace, int id) implements StaticProtocolObject
    {
        @Override
        public String toString() {
            return this.name();
        }
    }
}

