/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import net.minestom.server.MinecraftServer;
import net.minestom.server.command.CommandParser;
import net.minestom.server.command.CommandSender;
import net.minestom.server.command.Graph;
import net.minestom.server.command.GraphImpl;
import net.minestom.server.command.builder.arguments.Argument;
import net.minestom.server.command.builder.arguments.ArgumentCommand;
import net.minestom.server.command.builder.arguments.ArgumentEnum;
import net.minestom.server.command.builder.arguments.ArgumentGroup;
import net.minestom.server.command.builder.arguments.ArgumentLiteral;
import net.minestom.server.command.builder.arguments.ArgumentLoop;
import net.minestom.server.command.builder.arguments.ArgumentWord;
import net.minestom.server.entity.Player;
import net.minestom.server.network.packet.server.play.DeclareCommandsPacket;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

final class GraphConverter {
    private GraphConverter() {
    }

    @Contract(value="_, _ -> new")
    public static DeclareCommandsPacket createPacket(Graph graph, @Nullable Player player) {
        ArrayList<DeclareCommandsPacket.Node> nodes = new ArrayList<DeclareCommandsPacket.Node>();
        ArrayList<BiConsumer<Graph, Integer>> redirects = new ArrayList<BiConsumer<Graph, Integer>>();
        HashMap argToPacketId = new HashMap();
        AtomicInteger idSource = new AtomicInteger(0);
        int rootId = GraphConverter.append(graph.root(), nodes, redirects, idSource, null, player, argToPacketId)[0];
        for (BiConsumer biConsumer : redirects) {
            biConsumer.accept(graph, rootId);
        }
        return new DeclareCommandsPacket(nodes, rootId);
    }

    private static int[] append(Graph.Node graphNode, List<DeclareCommandsPacket.Node> to, List<BiConsumer<Graph, Integer>> redirects, AtomicInteger id, @Nullable AtomicInteger redirect, @Nullable Player player, Map<Argument<?>, Integer> argToPacketId) {
        ArgumentWord word;
        Graph.Execution execution = graphNode.execution();
        if (player != null && execution != null && !execution.test(player)) {
            return new int[0];
        }
        Argument<?> argument = graphNode.argument();
        List<Graph.Node> children = graphNode.next();
        DeclareCommandsPacket.Node node = new DeclareCommandsPacket.Node();
        int[] packetNodeChildren = new int[children.size()];
        int appendIndex = 0;
        for (int i = 0; i < children.size(); ++i) {
            int[] append = GraphConverter.append(children.get(i), to, redirects, id, redirect, player, argToPacketId);
            if (append.length > 0) {
                argToPacketId.put(children.get(i).argument(), append[0]);
            }
            if (append.length == 1) {
                packetNodeChildren[appendIndex++] = append[0];
                continue;
            }
            packetNodeChildren = Arrays.copyOf(packetNodeChildren, packetNodeChildren.length + append.length - 1);
            System.arraycopy(append, 0, packetNodeChildren, appendIndex, append.length);
            appendIndex += append.length;
        }
        node.children = packetNodeChildren;
        if (argument instanceof ArgumentLiteral) {
            ArgumentLiteral literal = (ArgumentLiteral)argument;
            if (literal.getId().isEmpty()) {
                node.flags = 0;
            } else {
                node.flags = GraphConverter.literal(false, false);
                node.name = argument.getId();
                if (redirect != null) {
                    node.flags = (byte)(node.flags | 8);
                    redirects.add((graph, root) -> {
                        node.redirectedNode = redirect.get();
                    });
                }
            }
            to.add(node);
            return new int[]{id.getAndIncrement()};
        }
        if (argument instanceof ArgumentCommand) {
            ArgumentCommand argCmd = (ArgumentCommand)argument;
            node.flags = GraphConverter.literal(false, true);
            node.name = argument.getId();
            String shortcut = argCmd.getShortcut();
            if (shortcut.isEmpty()) {
                redirects.add((graph, root) -> {
                    node.redirectedNode = root;
                });
            } else {
                redirects.add((graph, root) -> {
                    CommandSender sender = player == null ? MinecraftServer.getCommandManager().getConsoleSender() : player;
                    List<Argument<?>> args = CommandParser.parser().parse(sender, (Graph)graph, shortcut).args();
                    Argument<?> last = args.get(args.size() - 1);
                    node.redirectedNode = last.allowSpace() ? ((Integer)argToPacketId.get(args.get(args.size() - 2))).intValue() : ((Integer)argToPacketId.get(last)).intValue();
                });
            }
            to.add(node);
            return new int[]{id.getAndIncrement()};
        }
        if (argument instanceof ArgumentEnum || argument instanceof ArgumentWord && (word = (ArgumentWord)argument).hasRestrictions()) {
            List<String> entries = argument instanceof ArgumentEnum ? ((ArgumentEnum)argument).entries() : Arrays.stream(((ArgumentWord)argument).getRestrictions()).toList();
            int[] res = new int[entries.size()];
            for (int i = 0; i < res.length; ++i) {
                String entry = entries.get(i);
                DeclareCommandsPacket.Node subNode = new DeclareCommandsPacket.Node();
                subNode.children = node.children;
                subNode.flags = GraphConverter.literal(false, false);
                subNode.name = entry;
                if (redirect != null) {
                    subNode.flags = (byte)(subNode.flags | 8);
                    redirects.add((graph, root) -> {
                        subNode.redirectedNode = redirect.get();
                    });
                }
                to.add(subNode);
                res[i] = id.getAndIncrement();
            }
            return res;
        }
        if (argument instanceof ArgumentGroup) {
            ArgumentGroup special = (ArgumentGroup)argument;
            List<Argument<?>> entries = special.group();
            int[] res = null;
            int[] last = new int[]{};
            for (int i = 0; i < entries.size(); ++i) {
                int[] l;
                Argument<?> entry = entries.get(i);
                if (i == entries.size() - 1) {
                    for (int n : l = GraphConverter.append(new GraphImpl.NodeImpl(entry, null, List.of()), to, redirects, id, redirect, player, argToPacketId)) {
                        to.get((int)n).children = node.children;
                    }
                    for (int n : last) {
                        to.get((int)n).children = l;
                    }
                    return res == null ? l : res;
                }
                if (i == 0) {
                    res = GraphConverter.append(new GraphImpl.NodeImpl(entry, null, List.of()), to, redirects, id, null, player, argToPacketId);
                    last = res;
                    continue;
                }
                l = GraphConverter.append(new GraphImpl.NodeImpl(entry, null, List.of()), to, redirects, id, null, player, argToPacketId);
                for (int n : last) {
                    to.get((int)n).children = l;
                }
                last = l;
            }
            throw new RuntimeException("Arg group must have child args.");
        }
        if (argument instanceof ArgumentLoop) {
            ArgumentLoop special = (ArgumentLoop)argument;
            AtomicInteger r = new AtomicInteger();
            int[] res = new int[special.arguments().size()];
            List arguments = special.arguments();
            int appendIndex2 = 0;
            for (int i = 0; i < arguments.size(); ++i) {
                Argument arg = arguments.get(i);
                int[] append = GraphConverter.append(new GraphImpl.NodeImpl(arg, null, List.of()), to, redirects, id, r, player, argToPacketId);
                if (append.length == 1) {
                    res[appendIndex2++] = append[0];
                    continue;
                }
                res = Arrays.copyOf(res, res.length + append.length - 1);
                System.arraycopy(append, 0, res, appendIndex2, append.length);
                appendIndex2 += append.length;
            }
            r.set(id.get());
            return res;
        }
        boolean hasSuggestion = argument.hasSuggestion();
        node.flags = GraphConverter.arg(false, hasSuggestion);
        node.name = argument.getId();
        node.parser = argument.parser();
        node.properties = argument.nodeProperties();
        if (redirect != null) {
            node.flags = (byte)(node.flags | 8);
            redirects.add((graph, root) -> {
                node.redirectedNode = redirect.get();
            });
        }
        if (hasSuggestion) {
            node.suggestionsType = argument.suggestionType().getIdentifier();
        }
        to.add(node);
        return new int[]{id.getAndIncrement()};
    }

    private static byte literal(boolean executable, boolean hasRedirect) {
        return DeclareCommandsPacket.getFlag(DeclareCommandsPacket.NodeType.LITERAL, executable, hasRedirect, false);
    }

    private static byte arg(boolean executable, boolean hasSuggestion) {
        return DeclareCommandsPacket.getFlag(DeclareCommandsPacket.NodeType.ARGUMENT, executable, false, hasSuggestion);
    }
}

