package net.minestom.server.fluid;

import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.minestom.server.registry.FluidRegistries;
import net.minestom.server.utils.NamespaceID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * AUTOGENERATED by FluidGenerator
 */
public enum Fluid implements Keyed {
    EMPTY(NamespaceID.from("minecraft:empty")),

    FLOWING_WATER(NamespaceID.from("minecraft:flowing_water")),

    WATER(NamespaceID.from("minecraft:water")),

    FLOWING_LAVA(NamespaceID.from("minecraft:flowing_lava")),

    LAVA(NamespaceID.from("minecraft:lava"));

    private static final Fluid[] VALUES = values();

    @NotNull
    private final NamespaceID id;

    Fluid(@NotNull NamespaceID id) {
        this.id = id;
        FluidRegistries.fluids.put(id, this);
    }

    @Override
    @NotNull
    public Key key() {
        return this.id;
    }

    public short getId() {
        return (short) ordinal();
    }

    @NotNull
    public NamespaceID getNamespaceID() {
        return this.id;
    }

    @NotNull
    @Override
    public String toString() {
        return "[" + this.id + "]";
    }

    @Nullable
    public static Fluid fromId(short id) {
        if(id >= 0 && id < VALUES.length) {
            return VALUES[id];
        }
        return null;
    }
}
