/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils;

import java.util.Objects;
import net.kyori.adventure.key.Key;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;

public record NamespaceID(@NotNull String domain, @NotNull String path) implements CharSequence,
Key
{
    private static final String LEGAL_LETTERS = "[0123456789abcdefghijklmnopqrstuvwxyz_-]+";
    private static final String LEGAL_PATH_LETTERS = "[0123456789abcdefghijklmnopqrstuvwxyz./_-]+";

    public NamespaceID(@NotNull String domain, @NotNull String path) {
        domain = domain.intern();
        path = path.intern();
        assert (!domain.contains(".") && !domain.contains("/")) : "Domain cannot contain a dot nor a slash character (" + this.asString() + ")";
        assert (domain.matches(LEGAL_LETTERS)) : "Illegal character in domain (" + this.asString() + "). Must match [0123456789abcdefghijklmnopqrstuvwxyz_-]+";
        assert (path.matches(LEGAL_PATH_LETTERS)) : "Illegal character in path (" + this.asString() + "). Must match [0123456789abcdefghijklmnopqrstuvwxyz./_-]+";
    }

    @NotNull
    public static NamespaceID from(@NotNull String namespace) {
        String path;
        String domain;
        int index = namespace.indexOf(58);
        if (index == -1) {
            domain = "minecraft";
            path = namespace;
        } else {
            domain = namespace.substring(0, index);
            path = namespace.substring(index + 1);
        }
        return new NamespaceID(domain, path);
    }

    @NotNull
    public static NamespaceID from(@NotNull String domain, @NotNull String path) {
        return new NamespaceID(domain, path);
    }

    @NotNull
    public static NamespaceID from(@NotNull Key key) {
        return new NamespaceID(key.namespace(), key.value());
    }

    @Override
    public int length() {
        return this.domain.length() + 1 + this.path.length();
    }

    @Override
    public char charAt(int index) {
        if (index < this.domain.length()) {
            return this.domain.charAt(index);
        }
        if (index == this.domain.length()) {
            return ':';
        }
        return this.path.charAt(index - this.domain.length() - 1);
    }

    @Override
    @NotNull
    public CharSequence subSequence(int start, int end) {
        return this.asString().subSequence(start, end);
    }

    @Pattern(value="[a-z0-9_\\-.]+")
    @NotNull
    public String namespace() {
        return this.domain;
    }

    @NotNull
    public String value() {
        return this.path;
    }

    @NotNull
    public String asString() {
        return this.domain + ":" + this.path;
    }

    @Override
    @NotNull
    public String toString() {
        return this.asString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Key)) {
            return false;
        }
        Key that = (Key)o;
        return Objects.equals(this.domain, that.namespace()) && Objects.equals(this.path, that.value());
    }

    @Override
    public int hashCode() {
        int result = this.domain.hashCode();
        result = 31 * result + this.path.hashCode();
        return result;
    }
}

