/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.tag;

import java.util.UUID;
import java.util.function.Function;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.BinaryTagType;
import net.kyori.adventure.nbt.BinaryTagTypes;
import net.kyori.adventure.nbt.ByteBinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.DoubleBinaryTag;
import net.kyori.adventure.nbt.FloatBinaryTag;
import net.kyori.adventure.nbt.IntArrayBinaryTag;
import net.kyori.adventure.nbt.IntBinaryTag;
import net.kyori.adventure.nbt.LongBinaryTag;
import net.kyori.adventure.nbt.ShortBinaryTag;
import net.kyori.adventure.nbt.StringBinaryTag;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.minestom.server.ServerFlag;
import net.minestom.server.item.ItemStack;
import net.minestom.server.tag.TagHandler;
import net.minestom.server.tag.TagSerializer;
import net.minestom.server.utils.UniqueIdUtils;

final class Serializers {
    static final Entry<Byte, ByteBinaryTag> BYTE = new Entry<Byte, ByteBinaryTag>(BinaryTagTypes.BYTE, ByteBinaryTag::value, ByteBinaryTag::byteBinaryTag);
    static final Entry<Boolean, ByteBinaryTag> BOOLEAN = new Entry<Boolean, ByteBinaryTag>(BinaryTagTypes.BYTE, b -> b.value() != 0, b -> b != false ? ByteBinaryTag.ONE : ByteBinaryTag.ZERO);
    static final Entry<Short, ShortBinaryTag> SHORT = new Entry<Short, ShortBinaryTag>(BinaryTagTypes.SHORT, ShortBinaryTag::value, ShortBinaryTag::shortBinaryTag);
    static final Entry<Integer, IntBinaryTag> INT = new Entry<Integer, IntBinaryTag>(BinaryTagTypes.INT, IntBinaryTag::value, IntBinaryTag::intBinaryTag);
    static final Entry<Long, LongBinaryTag> LONG = new Entry<Long, LongBinaryTag>(BinaryTagTypes.LONG, LongBinaryTag::value, LongBinaryTag::longBinaryTag);
    static final Entry<Float, FloatBinaryTag> FLOAT = new Entry<Float, FloatBinaryTag>(BinaryTagTypes.FLOAT, FloatBinaryTag::value, FloatBinaryTag::floatBinaryTag);
    static final Entry<Double, DoubleBinaryTag> DOUBLE = new Entry<Double, DoubleBinaryTag>(BinaryTagTypes.DOUBLE, DoubleBinaryTag::value, DoubleBinaryTag::doubleBinaryTag);
    static final Entry<String, StringBinaryTag> STRING = new Entry<String, StringBinaryTag>(BinaryTagTypes.STRING, StringBinaryTag::value, StringBinaryTag::stringBinaryTag);
    static final Entry<BinaryTag, BinaryTag> NBT_ENTRY = new Entry(null, Function.identity(), Function.identity());
    static final Entry<UUID, IntArrayBinaryTag> UUID = new Entry<UUID, IntArrayBinaryTag>(BinaryTagTypes.INT_ARRAY, UniqueIdUtils::fromNbt, UniqueIdUtils::toNbt);
    static final Entry<ItemStack, CompoundBinaryTag> ITEM = new Entry<ItemStack, CompoundBinaryTag>(BinaryTagTypes.COMPOUND, ItemStack::fromItemNBT, ItemStack::toItemNBT);
    static final Entry<Component, StringBinaryTag> COMPONENT = new Entry<Component, StringBinaryTag>(BinaryTagTypes.STRING, input -> GsonComponentSerializer.gson().deserialize((Object)input.value()), component -> StringBinaryTag.stringBinaryTag((String)((String)GsonComponentSerializer.gson().serialize(component))));
    static final Entry<Object, ByteBinaryTag> EMPTY = new Entry<Object, ByteBinaryTag>(BinaryTagTypes.BYTE, unused -> null, component -> null);

    Serializers() {
    }

    static <T> Entry<T, CompoundBinaryTag> fromTagSerializer(TagSerializer<T> serializer) {
        return new Entry<Object, CompoundBinaryTag>(BinaryTagTypes.COMPOUND, compound -> {
            if (!ServerFlag.SERIALIZE_EMPTY_COMPOUND && compound.size() == 0) {
                return null;
            }
            return serializer.read(TagHandler.fromCompound(compound));
        }, value -> {
            if (value == null) {
                return CompoundBinaryTag.empty();
            }
            TagHandler handler = TagHandler.newHandler();
            serializer.write(handler, value);
            return handler.asCompound();
        });
    }

    record Entry<T, N extends BinaryTag>(BinaryTagType<N> nbtType, Function<N, T> reader, Function<T, N> writer, boolean isPath) {
        Entry(BinaryTagType<N> nbtType, Function<N, T> reader, Function<T, N> writer) {
            this(nbtType, reader, writer, false);
        }

        T read(N nbt) {
            return this.reader.apply(nbt);
        }

        N write(T value) {
            return (N)((BinaryTag)this.writer.apply(value));
        }
    }
}

