/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.Collection;
import java.util.List;
import net.minestom.server.entity.attribute.Attribute;
import net.minestom.server.entity.attribute.AttributeModifier;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import org.jetbrains.annotations.NotNull;

public record EntityAttributesPacket(int entityId, List<Property> properties) implements ServerPacket.Play
{
    public static final int MAX_ENTRIES = 1024;

    public EntityAttributesPacket {
        properties = List.copyOf(properties);
    }

    public EntityAttributesPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.VAR_INT), reader.readCollection(Property.NETWORK_TYPE, 1024));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.VAR_INT, this.entityId);
        writer.writeCollection(Property.NETWORK_TYPE, this.properties);
    }

    @Override
    public int playId() {
        return ServerPacketIdentifier.ENTITY_ATTRIBUTES;
    }

    public record Property(Attribute attribute, double value, Collection<AttributeModifier> modifiers) {
        public static final NetworkBuffer.Type<Property> NETWORK_TYPE = new NetworkBuffer.Type<Property>(){

            @Override
            public void write(@NotNull NetworkBuffer buffer, Property value) {
                buffer.write(Attribute.NETWORK_TYPE, value.attribute);
                buffer.write(NetworkBuffer.DOUBLE, value.value);
                buffer.writeCollection(AttributeModifier.NETWORK_TYPE, value.modifiers);
            }

            @Override
            public Property read(@NotNull NetworkBuffer buffer) {
                return new Property(buffer.read(Attribute.NETWORK_TYPE), buffer.read(NetworkBuffer.DOUBLE), buffer.readCollection(AttributeModifier.NETWORK_TYPE, Short.MAX_VALUE));
            }
        };

        public Property {
            modifiers = List.copyOf(modifiers);
        }
    }
}

