/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.UnaryOperator;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.minestom.server.adventure.AdventurePacketConvertor;
import net.minestom.server.adventure.ComponentHolder;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import org.jetbrains.annotations.NotNull;

public record BossBarPacket(@NotNull UUID uuid, @NotNull Action action) implements ServerPacket.Play,
ServerPacket.ComponentHolding
{
    public BossBarPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.UUID), (Action)((Object)(switch (reader.read(NetworkBuffer.VAR_INT)) {
            case 0 -> new AddAction(reader);
            case 1 -> new RemoveAction();
            case 2 -> new UpdateHealthAction(reader);
            case 3 -> new UpdateTitleAction(reader);
            case 4 -> new UpdateStyleAction(reader);
            case 5 -> new UpdateFlagsAction(reader);
            default -> throw new RuntimeException("Unknown action id");
        })));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.UUID, this.uuid);
        writer.write(NetworkBuffer.VAR_INT, this.action.id());
        writer.write(this.action);
    }

    @Override
    @NotNull
    public Collection<Component> components() {
        Collection<Component> collection;
        Action action = this.action;
        if (action instanceof ComponentHolder) {
            ComponentHolder holder = (ComponentHolder)((Object)action);
            collection = holder.components();
        } else {
            collection = List.of();
        }
        return collection;
    }

    @Override
    @NotNull
    public ServerPacket copyWithOperator(@NotNull UnaryOperator<Component> operator) {
        BossBarPacket bossBarPacket;
        Action action = this.action;
        if (action instanceof ComponentHolder) {
            ComponentHolder holder = (ComponentHolder)((Object)action);
            bossBarPacket = new BossBarPacket(this.uuid, (Action)holder.copyWithOperator(operator));
        } else {
            bossBarPacket = this;
        }
        return bossBarPacket;
    }

    @Override
    public int playId() {
        return ServerPacketIdentifier.BOSS_BAR;
    }

    public static sealed interface Action
    extends NetworkBuffer.Writer
    permits AddAction, RemoveAction, UpdateHealthAction, UpdateTitleAction, UpdateStyleAction, UpdateFlagsAction {
        public int id();
    }

    public record AddAction(@NotNull Component title, float health, @NotNull BossBar.Color color, @NotNull BossBar.Overlay overlay, byte flags) implements Action,
    ComponentHolder<AddAction>
    {
        public AddAction(@NotNull BossBar bar) {
            this(bar.name(), bar.progress(), bar.color(), bar.overlay(), AdventurePacketConvertor.getBossBarFlagValue(bar.flags()));
        }

        public AddAction(@NotNull NetworkBuffer reader) {
            this(reader.read(NetworkBuffer.COMPONENT), reader.read(NetworkBuffer.FLOAT).floatValue(), BossBar.Color.values()[reader.read(NetworkBuffer.VAR_INT)], BossBar.Overlay.values()[reader.read(NetworkBuffer.VAR_INT)], reader.read(NetworkBuffer.BYTE));
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.COMPONENT, this.title);
            writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.health));
            writer.write(NetworkBuffer.VAR_INT, AdventurePacketConvertor.getBossBarColorValue(this.color));
            writer.write(NetworkBuffer.VAR_INT, AdventurePacketConvertor.getBossBarOverlayValue(this.overlay));
            writer.write(NetworkBuffer.BYTE, this.flags);
        }

        @Override
        public int id() {
            return 0;
        }

        @Override
        @NotNull
        public Collection<Component> components() {
            return List.of(this.title);
        }

        @Override
        @NotNull
        public AddAction copyWithOperator(@NotNull UnaryOperator<Component> operator) {
            return new AddAction((Component)operator.apply(this.title), this.health, this.color, this.overlay, this.flags);
        }
    }

    public record RemoveAction() implements Action
    {
        @Override
        public void write(@NotNull NetworkBuffer writer) {
        }

        @Override
        public int id() {
            return 1;
        }
    }

    public record UpdateHealthAction(float health) implements Action
    {
        public UpdateHealthAction(@NotNull BossBar bar) {
            this(bar.progress());
        }

        public UpdateHealthAction(@NotNull NetworkBuffer reader) {
            this(reader.read(NetworkBuffer.FLOAT).floatValue());
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.health));
        }

        @Override
        public int id() {
            return 2;
        }
    }

    public record UpdateTitleAction(@NotNull Component title) implements Action,
    ComponentHolder<UpdateTitleAction>
    {
        public UpdateTitleAction(@NotNull BossBar bar) {
            this(bar.name());
        }

        public UpdateTitleAction(@NotNull NetworkBuffer reader) {
            this(reader.read(NetworkBuffer.COMPONENT));
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.COMPONENT, this.title);
        }

        @Override
        public int id() {
            return 3;
        }

        @Override
        @NotNull
        public Collection<Component> components() {
            return List.of(this.title);
        }

        @Override
        @NotNull
        public UpdateTitleAction copyWithOperator(@NotNull UnaryOperator<Component> operator) {
            return new UpdateTitleAction((Component)operator.apply(this.title));
        }
    }

    public record UpdateStyleAction(@NotNull BossBar.Color color, @NotNull BossBar.Overlay overlay) implements Action
    {
        public UpdateStyleAction(@NotNull BossBar bar) {
            this(bar.color(), bar.overlay());
        }

        public UpdateStyleAction(@NotNull NetworkBuffer reader) {
            this(BossBar.Color.values()[reader.read(NetworkBuffer.VAR_INT)], BossBar.Overlay.values()[reader.read(NetworkBuffer.VAR_INT)]);
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.VAR_INT, AdventurePacketConvertor.getBossBarColorValue(this.color));
            writer.write(NetworkBuffer.VAR_INT, AdventurePacketConvertor.getBossBarOverlayValue(this.overlay));
        }

        @Override
        public int id() {
            return 4;
        }
    }

    public record UpdateFlagsAction(byte flags) implements Action
    {
        public UpdateFlagsAction(@NotNull BossBar bar) {
            this(AdventurePacketConvertor.getBossBarFlagValue(bar.flags()));
        }

        public UpdateFlagsAction(@NotNull NetworkBuffer reader) {
            this(reader.read(NetworkBuffer.BYTE));
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.BYTE, this.flags);
        }

        @Override
        public int id() {
            return 5;
        }
    }
}

