/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.client.play;

import net.minestom.server.crypto.ArgumentSignatures;
import net.minestom.server.crypto.LastSeenMessages;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.client.ClientPacket;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;

public record ClientSignedCommandChatPacket(@NotNull String message, long timestamp, long salt, @NotNull ArgumentSignatures signatures,  @NotNull LastSeenMessages.Update lastSeenMessages) implements ClientPacket
{
    public ClientSignedCommandChatPacket(@NotNull String message, long timestamp, long salt, @NotNull ArgumentSignatures signatures, LastSeenMessages.Update lastSeenMessages) {
        Check.argCondition(message.length() > 256, "Message length cannot be greater than 256");
    }

    public ClientSignedCommandChatPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.STRING), reader.read(NetworkBuffer.LONG), reader.read(NetworkBuffer.LONG), new ArgumentSignatures(reader), new LastSeenMessages.Update(reader));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.STRING, this.message);
        writer.write(NetworkBuffer.LONG, this.timestamp);
        writer.write(NetworkBuffer.LONG, this.salt);
        writer.write(this.signatures);
        writer.write(this.lastSeenMessages);
    }
}

