/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.client.play;

import net.minestom.server.coordinate.Point;
import net.minestom.server.instance.block.BlockFace;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.client.ClientPacket;
import org.jetbrains.annotations.NotNull;

public record ClientPlayerDiggingPacket(@NotNull Status status, @NotNull Point blockPosition, @NotNull BlockFace blockFace, int sequence) implements ClientPacket
{
    public ClientPlayerDiggingPacket(@NotNull NetworkBuffer reader) {
        this(reader.readEnum(Status.class), reader.read(NetworkBuffer.BLOCK_POSITION), BlockFace.values()[reader.read(NetworkBuffer.BYTE)], reader.read(NetworkBuffer.VAR_INT));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.writeEnum(Status.class, this.status);
        writer.write(NetworkBuffer.BLOCK_POSITION, this.blockPosition);
        writer.write(NetworkBuffer.BYTE, (byte)this.blockFace.ordinal());
        writer.write(NetworkBuffer.VAR_INT, this.sequence);
    }

    public static enum Status {
        STARTED_DIGGING,
        CANCELLED_DIGGING,
        FINISHED_DIGGING,
        DROP_ITEM_STACK,
        DROP_ITEM,
        UPDATE_ITEM_STATE,
        SWAP_ITEM_HAND;

    }
}

