/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.enchant;

import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.TagStringIOExt;
import net.kyori.adventure.text.Component;
import net.minestom.server.component.DataComponentMap;
import net.minestom.server.entity.EquipmentSlotGroup;
import net.minestom.server.gamedata.tags.Tag;
import net.minestom.server.item.Material;
import net.minestom.server.item.enchant.EffectComponent;
import net.minestom.server.item.enchant.Enchantment;
import net.minestom.server.registry.ObjectSet;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.Registry;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class EnchantmentImpl
extends Record
implements Enchantment {
    @NotNull
    private final Component description;
    @NotNull
    private final ObjectSet<Enchantment> exclusiveSet;
    @NotNull
    private final ObjectSet<Material> supportedItems;
    @NotNull
    private final ObjectSet<Material> primaryItems;
    private final int weight;
    private final int maxLevel;
    @NotNull
    private final Enchantment.Cost minCost;
    @NotNull
    private final Enchantment.Cost maxCost;
    private final int anvilCost;
    @NotNull
    private final List<EquipmentSlotGroup> slots;
    @NotNull
    private final DataComponentMap effects;
    @Nullable
    private final Registry.EnchantmentEntry registry;
    private static final BinaryTagSerializer<ObjectSet<Enchantment>> ENCHANTMENT_OBJECT_SET_NBT_TYPE = ObjectSet.nbtType(Tag.BasicType.ENCHANTMENTS);
    private static final BinaryTagSerializer<ObjectSet<Material>> MATERIAL_OBJECT_SET_NBT_TYPE = ObjectSet.nbtType(Tag.BasicType.ITEMS);
    private static final BinaryTagSerializer<List<EquipmentSlotGroup>> SLOTS_NBT_TYPE = EquipmentSlotGroup.NBT_TYPE.list();
    static final BinaryTagSerializer<Enchantment> REGISTRY_NBT_TYPE = new BinaryTagSerializer<Enchantment>(){

        @Override
        @NotNull
        public BinaryTag write(@NotNull BinaryTagSerializer.Context context, @NotNull Enchantment value) {
            return ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().put("description", BinaryTagSerializer.NBT_COMPONENT.write(context, value.description()))).put("exclusive_set", ENCHANTMENT_OBJECT_SET_NBT_TYPE.write(context, value.exclusiveSet()))).put("supported_items", MATERIAL_OBJECT_SET_NBT_TYPE.write(context, value.supportedItems()))).put("primary_items", MATERIAL_OBJECT_SET_NBT_TYPE.write(context, value.primaryItems()))).putInt("weight", value.weight())).putInt("max_level", value.maxLevel())).put("min_cost", Enchantment.Cost.NBT_TYPE.write(context, value.minCost()))).put("max_cost", Enchantment.Cost.NBT_TYPE.write(context, value.maxCost()))).putInt("anvil_cost", value.anvilCost())).put("slots", SLOTS_NBT_TYPE.write(context, value.slots()))).put("effects", EffectComponent.MAP_NBT_TYPE.write(context, value.effects()))).build();
        }

        @Override
        @NotNull
        public Enchantment read(@NotNull BinaryTagSerializer.Context context, @NotNull BinaryTag raw) {
            DataComponentMap dataComponentMap;
            if (!(raw instanceof CompoundBinaryTag)) {
                throw new IllegalArgumentException("Expected a compound tag");
            }
            CompoundBinaryTag tag = (CompoundBinaryTag)raw;
            int n = tag.getInt("weight");
            int n2 = tag.getInt("max_level");
            int n3 = tag.getInt("anvil_cost");
            BinaryTag binaryTag = tag.get("effects");
            if (binaryTag instanceof CompoundBinaryTag) {
                CompoundBinaryTag effects = (CompoundBinaryTag)binaryTag;
                dataComponentMap = EffectComponent.MAP_NBT_TYPE.read(context, (BinaryTag)effects);
            } else {
                dataComponentMap = DataComponentMap.EMPTY;
            }
            return new EnchantmentImpl(BinaryTagSerializer.NBT_COMPONENT.read(context, tag.get("description")), ENCHANTMENT_OBJECT_SET_NBT_TYPE.read(context, tag.get("exclusive_set")), MATERIAL_OBJECT_SET_NBT_TYPE.read(context, tag.get("supported_items")), MATERIAL_OBJECT_SET_NBT_TYPE.read(context, tag.get("primary_items")), n, n2, Enchantment.Cost.NBT_TYPE.read(context, tag.get("min_cost")), Enchantment.Cost.NBT_TYPE.read(context, tag.get("max_cost")), n3, SLOTS_NBT_TYPE.read(context, tag.get("slots")), dataComponentMap, null);
        }
    };

    EnchantmentImpl(@NotNull Component description, @NotNull ObjectSet<Enchantment> exclusiveSet, @NotNull ObjectSet<Material> supportedItems, @NotNull ObjectSet<Material> primaryItems, int weight, int maxLevel, @NotNull Enchantment.Cost minCost, @NotNull Enchantment.Cost maxCost, int anvilCost, @NotNull List<EquipmentSlotGroup> slots, @NotNull DataComponentMap effects, @Nullable Registry.EnchantmentEntry registry) {
        slots = List.copyOf(slots);
        this.description = description;
        this.exclusiveSet = exclusiveSet;
        this.supportedItems = supportedItems;
        this.primaryItems = primaryItems;
        this.weight = weight;
        this.maxLevel = maxLevel;
        this.minCost = minCost;
        this.maxCost = maxCost;
        this.anvilCost = anvilCost;
        this.slots = slots;
        this.effects = effects;
        this.registry = registry;
    }

    EnchantmentImpl(@NotNull Registries registries, @NotNull Registry.EnchantmentEntry registry) {
        this(EnchantmentImpl.fromRawRegistry(registries, registry.raw()), registry);
    }

    EnchantmentImpl(@NotNull Enchantment enchantment, @NotNull Registry.EnchantmentEntry registry) {
        this(enchantment.description(), enchantment.exclusiveSet(), enchantment.supportedItems(), enchantment.primaryItems(), enchantment.weight(), enchantment.maxLevel(), enchantment.minCost(), enchantment.maxCost(), enchantment.anvilCost(), enchantment.slots(), enchantment.effects(), registry);
    }

    @NotNull
    private static Enchantment fromRawRegistry(@NotNull Registries registries, @NotNull String raw) {
        try {
            BinaryTagSerializer.ContextWithRegistries context = new BinaryTagSerializer.ContextWithRegistries(registries, false);
            return REGISTRY_NBT_TYPE.read(context, TagStringIOExt.readTag(raw));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{EnchantmentImpl.class, "description;exclusiveSet;supportedItems;primaryItems;weight;maxLevel;minCost;maxCost;anvilCost;slots;effects;registry", "description", "exclusiveSet", "supportedItems", "primaryItems", "weight", "maxLevel", "minCost", "maxCost", "anvilCost", "slots", "effects", "registry"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{EnchantmentImpl.class, "description;exclusiveSet;supportedItems;primaryItems;weight;maxLevel;minCost;maxCost;anvilCost;slots;effects;registry", "description", "exclusiveSet", "supportedItems", "primaryItems", "weight", "maxLevel", "minCost", "maxCost", "anvilCost", "slots", "effects", "registry"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{EnchantmentImpl.class, "description;exclusiveSet;supportedItems;primaryItems;weight;maxLevel;minCost;maxCost;anvilCost;slots;effects;registry", "description", "exclusiveSet", "supportedItems", "primaryItems", "weight", "maxLevel", "minCost", "maxCost", "anvilCost", "slots", "effects", "registry"}, this, o);
    }

    @Override
    @NotNull
    public Component description() {
        return this.description;
    }

    @Override
    @NotNull
    public ObjectSet<Enchantment> exclusiveSet() {
        return this.exclusiveSet;
    }

    @Override
    @NotNull
    public ObjectSet<Material> supportedItems() {
        return this.supportedItems;
    }

    @Override
    @NotNull
    public ObjectSet<Material> primaryItems() {
        return this.primaryItems;
    }

    @Override
    public int weight() {
        return this.weight;
    }

    @Override
    public int maxLevel() {
        return this.maxLevel;
    }

    @Override
    @NotNull
    public Enchantment.Cost minCost() {
        return this.minCost;
    }

    @Override
    @NotNull
    public Enchantment.Cost maxCost() {
        return this.maxCost;
    }

    @Override
    public int anvilCost() {
        return this.anvilCost;
    }

    @Override
    @NotNull
    public List<EquipmentSlotGroup> slots() {
        return this.slots;
    }

    @Override
    @NotNull
    public DataComponentMap effects() {
        return this.effects;
    }

    @Override
    @Nullable
    public Registry.EnchantmentEntry registry() {
        return this.registry;
    }
}

