/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.component;

import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.minestom.server.color.DyeColor;
import net.minestom.server.instance.block.banner.BannerPattern;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.NotNull;

public record BannerPatterns(@NotNull List<Layer> layers) {
    public static final int MAX_LAYERS = 1024;
    public static final NetworkBuffer.Type<BannerPatterns> NETWORK_TYPE = Layer.NETWORK_TYPE.list(1024).map(BannerPatterns::new, BannerPatterns::layers);
    public static final BinaryTagSerializer<BannerPatterns> NBT_TYPE = Layer.NBT_TYPE.list().map(BannerPatterns::new, BannerPatterns::layers);

    public BannerPatterns(@NotNull List<Layer> layers) {
        layers = List.copyOf(layers);
    }

    public BannerPatterns(@NotNull Layer layer) {
        this(List.of(layer));
    }

    public BannerPatterns(@NotNull DynamicRegistry.Key<BannerPattern> pattern, @NotNull DyeColor color) {
        this(new Layer(pattern, color));
    }

    @NotNull
    public BannerPatterns with(@NotNull Layer layer) {
        ArrayList<Layer> layers = new ArrayList<Layer>(this.layers);
        layers.add(layer);
        return new BannerPatterns(layers);
    }

    public record Layer(@NotNull DynamicRegistry.Key<BannerPattern> pattern, @NotNull DyeColor color) {
        public static final NetworkBuffer.Type<Layer> NETWORK_TYPE = new NetworkBuffer.Type<Layer>(){

            @Override
            public void write(@NotNull NetworkBuffer buffer, Layer value) {
                buffer.write(BannerPattern.NETWORK_TYPE, value.pattern);
                buffer.write(DyeColor.NETWORK_TYPE, value.color);
            }

            @Override
            public Layer read(@NotNull NetworkBuffer buffer) {
                return new Layer(buffer.read(BannerPattern.NETWORK_TYPE), buffer.read(DyeColor.NETWORK_TYPE));
            }
        };
        public static final BinaryTagSerializer<Layer> NBT_TYPE = new BinaryTagSerializer<Layer>(){

            @Override
            @NotNull
            public BinaryTag write(@NotNull BinaryTagSerializer.Context context, @NotNull Layer value) {
                return ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().put("pattern", BannerPattern.NBT_TYPE.write(value.pattern))).put("color", DyeColor.NBT_TYPE.write(value.color))).build();
            }

            @Override
            @NotNull
            public Layer read(@NotNull BinaryTagSerializer.Context context, @NotNull BinaryTag tag) {
                if (!(tag instanceof CompoundBinaryTag)) {
                    throw new IllegalArgumentException("Expected a compound tag");
                }
                CompoundBinaryTag compound = (CompoundBinaryTag)tag;
                return new Layer(BannerPattern.NBT_TYPE.read(context, compound.get("pattern")), DyeColor.NBT_TYPE.read(context, compound.get("color")));
            }
        };
    }
}

