package net.minestom.server.network.packet.server.play;

import net.minestom.server.coordinate.Point;
import net.minestom.server.instance.block.Block;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import org.jetbrains.annotations.NotNull;

import static net.minestom.server.network.NetworkBuffer.*;

public record BlockActionPacket(@NotNull Point blockPosition, byte actionId,
                                byte actionParam, int blockId) implements ServerPacket.Play {
    public BlockActionPacket(Point blockPosition, byte actionId, byte actionParam, Block block) {
        this(blockPosition, actionId, actionParam, block.id());
    }

    public BlockActionPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(BLOCK_POSITION), reader.read(BYTE),
                reader.read(BYTE), reader.read(VAR_INT));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(BLOCK_POSITION, blockPosition);
        writer.write(BYTE, actionId);
        writer.write(BYTE, actionParam);
        writer.write(VAR_INT, blockId);
    }

    @Override
    public int playId() {
        return ServerPacketIdentifier.BLOCK_ACTION;
    }
}
