/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault.economy.plugins;

import com.github.omwah.SDFEconomy.SDFEconomy;
import com.github.omwah.SDFEconomy.SDFEconomyAPI;
import java.util.List;
import java.util.logging.Logger;
import net.milkbowl.vault.economy.AbstractEconomy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;

public class Economy_SDFEconomy
extends AbstractEconomy {
    private final Logger log;
    private final String name = "SDFEconomy";
    private Plugin plugin = null;
    private SDFEconomyAPI api = null;

    public Economy_SDFEconomy(Plugin plugin) {
        this.plugin = plugin;
        this.log = plugin.getLogger();
        plugin.getServer().getPluginManager().registerEvents((Listener)new EconomyServerListener(this), plugin);
        this.load_api();
    }

    public void load_api() {
        SDFEconomy pluginSDF = (SDFEconomy)this.plugin.getServer().getPluginManager().getPlugin("SDFEconomy");
        if (!this.isEnabled() && pluginSDF != null) {
            this.api = pluginSDF.getAPI();
            this.log.info(String.format("[%s][Economy] %s hooked.", this.plugin.getDescription().getName(), "SDFEconomy"));
        }
    }

    public void unload_api() {
        SDFEconomy pluginSDF = (SDFEconomy)this.plugin.getServer().getPluginManager().getPlugin("SDFEconomy");
        if (this.isEnabled() && pluginSDF != null) {
            this.api = null;
            this.log.info(String.format("[%s][Economy] %s unhooked.", this.plugin.getDescription().getName(), "SDFEconomy"));
        }
    }

    @Override
    public boolean isEnabled() {
        return this.api != null;
    }

    @Override
    public String getName() {
        return "SDFEconomy";
    }

    @Override
    public boolean hasBankSupport() {
        return this.api.hasBankSupport();
    }

    @Override
    public int fractionalDigits() {
        return this.api.fractionalDigits();
    }

    @Override
    public String format(double amount) {
        return this.api.format(amount);
    }

    @Override
    public String currencyNamePlural() {
        return this.api.currencyNamePlural();
    }

    @Override
    public String currencyNameSingular() {
        return this.api.currencyNameSingular();
    }

    @Override
    public boolean hasAccount(String playerName) {
        return this.api.hasAccount(playerName);
    }

    @Override
    public double getBalance(String playerName) {
        return this.api.getBalance(playerName);
    }

    @Override
    public boolean has(String playerName, double amount) {
        return this.api.has(playerName, amount);
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        return this.api.withdrawPlayer(playerName, amount);
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, double amount) {
        return this.api.depositPlayer(playerName, amount);
    }

    @Override
    public EconomyResponse createBank(String name, String player) {
        return this.api.createBank(name, player);
    }

    @Override
    public EconomyResponse deleteBank(String name) {
        return this.api.deleteBank(name);
    }

    @Override
    public EconomyResponse bankBalance(String name) {
        return this.api.bankBalance(name);
    }

    @Override
    public EconomyResponse bankHas(String name, double amount) {
        return this.api.bankHas(name, amount);
    }

    @Override
    public EconomyResponse bankWithdraw(String name, double amount) {
        return this.api.bankWithdraw(name, amount);
    }

    @Override
    public EconomyResponse bankDeposit(String name, double amount) {
        return this.api.bankDeposit(name, amount);
    }

    @Override
    public EconomyResponse isBankOwner(String name, String playerName) {
        return this.api.isBankOwner(name, playerName);
    }

    @Override
    public EconomyResponse isBankMember(String name, String playerName) {
        return this.api.isBankMember(name, playerName);
    }

    @Override
    public List<String> getBanks() {
        return this.api.getBankNames();
    }

    @Override
    public boolean createPlayerAccount(String playerName) {
        return this.api.createPlayerAccount(playerName);
    }

    @Override
    public boolean hasAccount(String playerName, String worldName) {
        return this.hasAccount(playerName);
    }

    @Override
    public double getBalance(String playerName, String world) {
        return this.getBalance(playerName);
    }

    @Override
    public boolean has(String playerName, String worldName, double amount) {
        return this.has(playerName, amount);
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, String worldName, double amount) {
        return this.withdrawPlayer(playerName, amount);
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, String worldName, double amount) {
        return this.depositPlayer(playerName, amount);
    }

    @Override
    public boolean createPlayerAccount(String playerName, String worldName) {
        return this.createPlayerAccount(playerName);
    }

    public class EconomyServerListener
    implements Listener {
        Economy_SDFEconomy economy = null;

        public EconomyServerListener(Economy_SDFEconomy economy) {
            this.economy = economy;
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginEnable(PluginEnableEvent event) {
            if (event.getPlugin().getDescription().getName().equals("SDFEconomy")) {
                this.economy.load_api();
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginDisable(PluginDisableEvent event) {
            if (event.getPlugin().getDescription().getName().equals("SDFEconomy")) {
                this.economy.unload_api();
            }
        }
    }
}

