/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault.economy.plugins;

import ca.agnate.EconXP.EconXP;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.milkbowl.vault.economy.AbstractEconomy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;

public class Economy_EconXP
extends AbstractEconomy {
    private final Logger log;
    private final String name = "EconXP";
    private Plugin plugin = null;
    private EconXP econ = null;

    public Economy_EconXP(Plugin plugin) {
        Plugin econ;
        this.plugin = plugin;
        this.log = plugin.getLogger();
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new EconomyServerListener(this), plugin);
        this.log.log(Level.WARNING, "EconXP is an integer only economy, you may notice inconsistencies with accounts if you do not setup your other econ using plugins accordingly!");
        if (this.econ == null && (econ = plugin.getServer().getPluginManager().getPlugin("EconXP")) != null && econ.isEnabled()) {
            this.econ = (EconXP)econ;
            this.log.info(String.format("[%s][Economy] %s hooked.", plugin.getDescription().getName(), "EconXP"));
        }
    }

    @Override
    public boolean isEnabled() {
        return this.econ != null;
    }

    @Override
    public String getName() {
        return "EconXP";
    }

    @Override
    public String format(double amount) {
        amount = Math.ceil(amount);
        return String.format("%d %s", (int)amount, "experience");
    }

    @Override
    public String currencyNamePlural() {
        return "experience";
    }

    @Override
    public String currencyNameSingular() {
        return "experience";
    }

    @Override
    public double getBalance(String playerName) {
        OfflinePlayer player = this.econ.getPlayer(playerName);
        if (player == null) {
            return 0.0;
        }
        return this.econ.getExp(player);
    }

    @Override
    public boolean has(String playerName, double amount) {
        OfflinePlayer player = this.econ.getPlayer(playerName);
        if (player == null) {
            return false;
        }
        return this.econ.hasExp(player, (int)Math.ceil(amount));
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        OfflinePlayer player = this.econ.getPlayer(playerName);
        if (player == null) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Player does not exist");
        }
        double balance = this.econ.getExp(player);
        if ((amount = Math.ceil(amount)) < 0.0) {
            return new EconomyResponse(0.0, balance, EconomyResponse.ResponseType.FAILURE, "Cannot withdraw negative funds");
        }
        if (!this.econ.hasExp(player, (int)amount)) {
            return new EconomyResponse(0.0, balance, EconomyResponse.ResponseType.FAILURE, "Insufficient funds");
        }
        this.econ.removeExp(player, (int)amount);
        double finalBalance = this.econ.getExp(player);
        return new EconomyResponse(amount, finalBalance, EconomyResponse.ResponseType.SUCCESS, null);
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, double amount) {
        OfflinePlayer player = this.econ.getPlayer(playerName);
        if (player == null) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Player does not exist");
        }
        double balance = this.econ.getExp(player);
        if ((amount = Math.ceil(amount)) < 0.0) {
            return new EconomyResponse(0.0, balance, EconomyResponse.ResponseType.FAILURE, "Cannot withdraw negative funds");
        }
        this.econ.addExp(player, (int)amount);
        balance = this.econ.getExp(player);
        return new EconomyResponse(amount, balance, EconomyResponse.ResponseType.SUCCESS, null);
    }

    @Override
    public EconomyResponse createBank(String name, String player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "EconXP does not support bank accounts!");
    }

    @Override
    public EconomyResponse deleteBank(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "EconXP does not support bank accounts!");
    }

    @Override
    public EconomyResponse bankHas(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "EconXP does not support bank accounts!");
    }

    @Override
    public EconomyResponse bankWithdraw(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "EconXP does not support bank accounts!");
    }

    @Override
    public EconomyResponse bankDeposit(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "EconXP does not support bank accounts!");
    }

    @Override
    public EconomyResponse isBankOwner(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "EconXP does not support bank accounts!");
    }

    @Override
    public EconomyResponse isBankMember(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "EconXP does not support bank accounts!");
    }

    @Override
    public EconomyResponse bankBalance(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "EconXP does not support bank accounts!");
    }

    @Override
    public List<String> getBanks() {
        return new ArrayList<String>();
    }

    @Override
    public boolean hasBankSupport() {
        return false;
    }

    @Override
    public boolean hasAccount(String playerName) {
        return this.econ.getPlayer(playerName) != null;
    }

    @Override
    public boolean createPlayerAccount(String playerName) {
        return false;
    }

    @Override
    public int fractionalDigits() {
        return 0;
    }

    @Override
    public boolean hasAccount(String playerName, String worldName) {
        return this.hasAccount(playerName);
    }

    @Override
    public double getBalance(String playerName, String world) {
        return this.getBalance(playerName);
    }

    @Override
    public boolean has(String playerName, String worldName, double amount) {
        return this.has(playerName, amount);
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, String worldName, double amount) {
        return this.withdrawPlayer(playerName, amount);
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, String worldName, double amount) {
        return this.depositPlayer(playerName, amount);
    }

    @Override
    public boolean createPlayerAccount(String playerName, String worldName) {
        return this.createPlayerAccount(playerName);
    }

    public class EconomyServerListener
    implements Listener {
        Economy_EconXP economy = null;

        public EconomyServerListener(Economy_EconXP economy) {
            this.economy = economy;
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginEnable(PluginEnableEvent event) {
            Plugin eco;
            if (this.economy.econ == null && (eco = event.getPlugin()).getDescription().getName().equals("EconXP")) {
                this.economy.econ = (EconXP)eco;
                Economy_EconXP.this.log.info(String.format("[%s][Economy] %s hooked.", Economy_EconXP.this.plugin.getDescription().getName(), "EconXP"));
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginDisable(PluginDisableEvent event) {
            if (this.economy.econ != null && event.getPlugin().getDescription().getName().equals("EconXP")) {
                this.economy.econ = null;
                Economy_EconXP.this.log.info(String.format("[%s][Economy] %s unhooked.", Economy_EconXP.this.plugin.getDescription().getName(), "EconXP"));
            }
        }
    }
}

