/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault.economy.plugins;

import cosine.boseconomy.BOSEconomy;
import java.util.List;
import java.util.logging.Logger;
import net.milkbowl.vault.economy.AbstractEconomy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;

public class Economy_BOSE7
extends AbstractEconomy {
    private final Logger log;
    private final String name = "BOSEconomy";
    private Plugin plugin = null;
    private BOSEconomy economy = null;

    public Economy_BOSE7(Plugin plugin) {
        Plugin bose;
        this.plugin = plugin;
        this.log = plugin.getLogger();
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new EconomyServerListener(this), plugin);
        if (this.economy == null && (bose = plugin.getServer().getPluginManager().getPlugin("BOSEconomy")) != null && bose.isEnabled() && bose.getDescription().getVersion().startsWith("0.7")) {
            this.economy = (BOSEconomy)bose;
            this.log.info(String.format("[%s][Economy] %s hooked.", plugin.getDescription().getName(), "BOSEconomy"));
        }
    }

    @Override
    public String getName() {
        return "BOSEconomy";
    }

    @Override
    public boolean isEnabled() {
        if (this.economy == null) {
            return false;
        }
        return this.economy.isEnabled();
    }

    @Override
    public double getBalance(String playerName) {
        double balance;
        double fBalance = balance = this.economy.getPlayerMoneyDouble(playerName);
        return fBalance;
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        if (amount < 0.0) {
            return new EconomyResponse(0.0, this.economy.getPlayerMoneyDouble(playerName), EconomyResponse.ResponseType.FAILURE, "Cannot withdraw negative funds");
        }
        if (!this.has(playerName, amount)) {
            return new EconomyResponse(0.0, this.economy.getPlayerMoneyDouble(playerName), EconomyResponse.ResponseType.FAILURE, "Insufficient funds");
        }
        double balance = this.economy.getPlayerMoneyDouble(playerName);
        if (this.economy.setPlayerMoney(playerName, balance - amount, false)) {
            balance = this.economy.getPlayerMoneyDouble(playerName);
            return new EconomyResponse(amount, balance, EconomyResponse.ResponseType.SUCCESS, "");
        }
        return new EconomyResponse(0.0, balance, EconomyResponse.ResponseType.FAILURE, "Error withdrawing funds");
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, double amount) {
        if (amount < 0.0) {
            return new EconomyResponse(0.0, this.economy.getPlayerMoneyDouble(playerName), EconomyResponse.ResponseType.FAILURE, "Cannot deposit negative funds");
        }
        double balance = this.economy.getPlayerMoneyDouble(playerName);
        if (this.economy.setPlayerMoney(playerName, balance + amount, false)) {
            balance = this.economy.getPlayerMoneyDouble(playerName);
            return new EconomyResponse(amount, balance, EconomyResponse.ResponseType.SUCCESS, "");
        }
        return new EconomyResponse(0.0, balance, EconomyResponse.ResponseType.FAILURE, "Error depositing funds");
    }

    @Override
    public String currencyNamePlural() {
        return this.economy.getMoneyNamePlural();
    }

    @Override
    public String currencyNameSingular() {
        return this.economy.getMoneyName();
    }

    @Override
    public String format(double amount) {
        return this.economy.getMoneyFormatted(amount);
    }

    @Override
    public EconomyResponse createBank(String name, String player) {
        boolean success = this.economy.addBankOwner(name, player, false);
        if (success) {
            return new EconomyResponse(0.0, this.economy.getBankMoneyDouble(name), EconomyResponse.ResponseType.SUCCESS, "");
        }
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Unable to create that bank account.");
    }

    @Override
    public EconomyResponse deleteBank(String name) {
        boolean success = this.economy.removeBank(name);
        if (success) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.SUCCESS, "");
        }
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Unable to remove that bank account.");
    }

    @Override
    public EconomyResponse bankHas(String name, double amount) {
        if (!this.economy.bankExists(name)) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "That bank does not exist!");
        }
        double bankMoney = this.economy.getBankMoneyDouble(name);
        if (bankMoney < amount) {
            return new EconomyResponse(0.0, bankMoney, EconomyResponse.ResponseType.FAILURE, "The bank does not have enough money!");
        }
        return new EconomyResponse(0.0, bankMoney, EconomyResponse.ResponseType.SUCCESS, "");
    }

    @Override
    public EconomyResponse bankWithdraw(String name, double amount) {
        EconomyResponse er = this.bankHas(name, amount);
        if (!er.transactionSuccess()) {
            return er;
        }
        this.economy.addBankMoney(name, -amount, true);
        return new EconomyResponse(amount, this.economy.getBankMoneyDouble(name), EconomyResponse.ResponseType.SUCCESS, "");
    }

    @Override
    public EconomyResponse bankDeposit(String name, double amount) {
        if (!this.economy.bankExists(name)) {
            return new EconomyResponse(amount, 0.0, EconomyResponse.ResponseType.FAILURE, "That bank does not exist!");
        }
        this.economy.addBankMoney(name, amount, true);
        return new EconomyResponse(amount, this.economy.getBankMoneyDouble(name), EconomyResponse.ResponseType.SUCCESS, "");
    }

    @Override
    public EconomyResponse isBankOwner(String name, String playerName) {
        if (!this.economy.bankExists(name)) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "That bank does not exist!");
        }
        if (this.economy.isBankOwner(name, playerName)) {
            return new EconomyResponse(0.0, this.economy.getBankMoneyDouble(name), EconomyResponse.ResponseType.SUCCESS, "");
        }
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "That player is not a bank owner!");
    }

    @Override
    public EconomyResponse isBankMember(String name, String playerName) {
        if (!this.economy.bankExists(name)) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "That bank does not exist!");
        }
        if (this.economy.isBankMember(name, playerName)) {
            return new EconomyResponse(0.0, this.economy.getBankMoneyDouble(name), EconomyResponse.ResponseType.SUCCESS, "");
        }
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "That player is not a bank member!");
    }

    @Override
    public EconomyResponse bankBalance(String name) {
        if (!this.economy.bankExists(name)) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "That bank does not exist!");
        }
        double bankMoney = this.economy.getBankMoneyDouble(name);
        return new EconomyResponse(0.0, bankMoney, EconomyResponse.ResponseType.SUCCESS, null);
    }

    @Override
    public List<String> getBanks() {
        return this.economy.getBankList();
    }

    @Override
    public boolean has(String playerName, double amount) {
        return this.getBalance(playerName) >= amount;
    }

    @Override
    public boolean hasBankSupport() {
        return true;
    }

    @Override
    public boolean hasAccount(String playerName) {
        return this.economy.playerRegistered(playerName, false);
    }

    @Override
    public boolean createPlayerAccount(String playerName) {
        if (this.economy.playerRegistered(playerName, false)) {
            return false;
        }
        return this.economy.registerPlayer(playerName);
    }

    @Override
    public int fractionalDigits() {
        return this.economy.getFractionalDigits();
    }

    @Override
    public boolean hasAccount(String playerName, String worldName) {
        return this.hasAccount(playerName);
    }

    @Override
    public double getBalance(String playerName, String world) {
        return this.getBalance(playerName);
    }

    @Override
    public boolean has(String playerName, String worldName, double amount) {
        return this.has(playerName, amount);
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, String worldName, double amount) {
        return this.withdrawPlayer(playerName, amount);
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, String worldName, double amount) {
        return this.depositPlayer(playerName, amount);
    }

    @Override
    public boolean createPlayerAccount(String playerName, String worldName) {
        return this.createPlayerAccount(playerName);
    }

    public class EconomyServerListener
    implements Listener {
        Economy_BOSE7 economy = null;

        public EconomyServerListener(Economy_BOSE7 economy) {
            this.economy = economy;
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginEnable(PluginEnableEvent event) {
            Plugin bose;
            if (this.economy.economy == null && (bose = event.getPlugin()).getDescription().getName().equals("BOSEconomy") && bose.getDescription().getVersion().startsWith("0.7")) {
                this.economy.economy = (BOSEconomy)bose;
                Economy_BOSE7.this.log.info(String.format("[%s][Economy] %s hooked.", Economy_BOSE7.this.plugin.getDescription().getName(), "BOSEconomy"));
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginDisable(PluginDisableEvent event) {
            if (this.economy.economy != null && event.getPlugin().getDescription().getName().equals("BOSEconomy") && event.getPlugin().getDescription().getVersion().startsWith("0.7")) {
                this.economy.economy = null;
                Economy_BOSE7.this.log.info(String.format("[%s][Economy] %s unhooked.", Economy_BOSE7.this.plugin.getDescription().getName(), "BOSEconomy"));
            }
        }
    }
}

