/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault.economy.plugins;

import java.util.List;
import java.util.logging.Logger;
import me.igwb.GoldenChest.GoldenChestEconomy;
import net.milkbowl.vault.economy.AbstractEconomy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;

public class Economy_GoldenChestEconomy
extends AbstractEconomy {
    private static final Logger log = Logger.getLogger("Minecraft");
    private final String name = "GoldenChestEconomy";
    private Plugin plugin = null;
    private GoldenChestEconomy economy = null;

    public Economy_GoldenChestEconomy(Plugin plugin) {
        Plugin ec;
        this.plugin = plugin;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new EconomyServerListener(this), plugin);
        if (this.economy == null && (ec = plugin.getServer().getPluginManager().getPlugin("GoldenChestEconomy")) != null && ec.isEnabled() && ec.getClass().getName().equals("me.igwb.GoldenChest.GoldenChestEconomy")) {
            this.economy = (GoldenChestEconomy)ec;
            log.info(String.format("[%s][Economy] %s hooked.", plugin.getDescription().getName(), "GoldenChestEconomy"));
        }
    }

    @Override
    public boolean isEnabled() {
        if (this.economy == null) {
            return false;
        }
        return this.economy.isEnabled();
    }

    @Override
    public String getName() {
        return "GoldenChestEconomy";
    }

    @Override
    public boolean hasBankSupport() {
        return false;
    }

    @Override
    public int fractionalDigits() {
        return this.economy.getVaultConnector().fractionalDigits();
    }

    @Override
    public String format(double amount) {
        return this.economy.getVaultConnector().format(amount);
    }

    @Override
    public String currencyNamePlural() {
        return this.economy.getVaultConnector().currencyNamePlural();
    }

    @Override
    public String currencyNameSingular() {
        return this.economy.getVaultConnector().currencyNameSingular();
    }

    @Override
    public boolean hasAccount(String playerName) {
        return this.economy.getVaultConnector().hasAccount(playerName);
    }

    @Override
    public boolean hasAccount(String playerName, String worldName) {
        return this.economy.getVaultConnector().hasAccount(playerName, worldName);
    }

    @Override
    public double getBalance(String playerName) {
        return this.economy.getVaultConnector().getBalance(playerName);
    }

    @Override
    public double getBalance(String playerName, String world) {
        return this.economy.getVaultConnector().getBalance(playerName, world);
    }

    @Override
    public boolean has(String playerName, double amount) {
        return this.economy.getVaultConnector().has(playerName, amount);
    }

    @Override
    public boolean has(String playerName, String worldName, double amount) {
        return this.economy.getVaultConnector().has(playerName, worldName, amount);
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        if (amount < 0.0) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Cannot withdraw negative funds");
        }
        if (this.has(playerName, amount)) {
            this.economy.getVaultConnector().withdrawPlayer(playerName, amount);
            return new EconomyResponse(amount, this.getBalance(playerName), EconomyResponse.ResponseType.SUCCESS, null);
        }
        return new EconomyResponse(0.0, this.getBalance(playerName), EconomyResponse.ResponseType.FAILURE, "Insufficient funds");
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, String worldName, double amount) {
        return this.withdrawPlayer(playerName, amount);
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, double amount) {
        if (amount < 0.0) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Cannot desposit negative funds");
        }
        this.economy.getVaultConnector().depositPlayer(playerName, amount);
        return new EconomyResponse(amount, this.getBalance(playerName), EconomyResponse.ResponseType.SUCCESS, null);
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, String worldName, double amount) {
        return this.depositPlayer(playerName, amount);
    }

    @Override
    public EconomyResponse createBank(String name, String player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Banks are not supported!");
    }

    @Override
    public EconomyResponse deleteBank(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Banks are not supported!");
    }

    @Override
    public EconomyResponse bankBalance(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Banks are not supported!");
    }

    @Override
    public EconomyResponse bankHas(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Banks are not supported!");
    }

    @Override
    public EconomyResponse bankWithdraw(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Banks are not supported!");
    }

    @Override
    public EconomyResponse bankDeposit(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Banks are not supported!");
    }

    @Override
    public EconomyResponse isBankOwner(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Banks are not supported!");
    }

    @Override
    public EconomyResponse isBankMember(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Banks are not supported!");
    }

    @Override
    public List<String> getBanks() {
        return null;
    }

    @Override
    public boolean createPlayerAccount(String playerName) {
        return this.economy.getVaultConnector().createPlayerAccount(playerName);
    }

    @Override
    public boolean createPlayerAccount(String playerName, String worldName) {
        return this.economy.getVaultConnector().createPlayerAccount(playerName, worldName);
    }

    public class EconomyServerListener
    implements Listener {
        Economy_GoldenChestEconomy economy = null;

        public EconomyServerListener(Economy_GoldenChestEconomy economy_GoldenChestEconomy) {
            this.economy = economy_GoldenChestEconomy;
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginEnable(PluginEnableEvent event) {
            Plugin ec;
            if (this.economy.economy == null && (ec = event.getPlugin()).getDescription().getName().equals("GoldenChestEconomy") && ec.getClass().getName().equals("me.igwb.GoldenChest.GoldenChestEconomy")) {
                this.economy.economy = (GoldenChestEconomy)ec;
                log.info(String.format("[%s][Economy] %s hooked.", Economy_GoldenChestEconomy.this.plugin.getDescription().getName(), "GoldenChestEconomy"));
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginDisable(PluginDisableEvent event) {
            if (this.economy.economy != null && event.getPlugin().getDescription().getName().equals("GoldenChestEconomy")) {
                this.economy.economy = null;
                log.info(String.format("[%s][Economy] %s unhooked.", Economy_GoldenChestEconomy.this.plugin.getDescription().getName(), "GoldenChestEconomy"));
            }
        }
    }
}

