/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault.chat.plugins;

import com.overmc.overpermissions.Group;
import com.overmc.overpermissions.OverPermissions;
import com.overmc.overpermissions.OverPermissionsAPI;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;

public class Chat_OverPermissions
extends Chat {
    private static final String name = "OverPermissions_Chat";
    private Plugin plugin;
    private OverPermissions overPerms;
    private OverPermissionsAPI api;

    public Chat_OverPermissions(Plugin plugin, Permission perms) {
        super(perms);
        Plugin p;
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)new PermissionServerListener(this), plugin);
        if (this.overPerms == null && (p = plugin.getServer().getPluginManager().getPlugin("OverPermissions")) != null) {
            this.overPerms = (OverPermissions)p;
            plugin.getLogger().info(String.format("[%s][Chat] %s hooked.", plugin.getDescription().getName(), "OverPermissions"));
        }
        if (this.api == null && this.overPerms != null) {
            this.api = this.overPerms.getAPI();
        }
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public boolean isEnabled() {
        return this.overPerms != null;
    }

    @Override
    public String getPlayerPrefix(String world, String player) {
        return this.getPlayerInfoString(world, player, "prefix", "");
    }

    @Override
    public void setPlayerPrefix(String world, String player, String prefix) {
        this.setPlayerInfoString(world, player, "prefix", prefix);
    }

    @Override
    public String getPlayerSuffix(String world, String player) {
        return this.getPlayerInfoString(world, player, "suffix", "");
    }

    @Override
    public void setPlayerSuffix(String world, String player, String suffix) {
        this.setPlayerInfoString(world, player, "suffix", suffix);
    }

    @Override
    public String getGroupPrefix(String world, String group) {
        return this.getGroupInfoString(world, group, "prefix", "");
    }

    @Override
    public void setGroupPrefix(String world, String group, String prefix) {
        this.setGroupInfoString(world, group, "prefix", prefix);
    }

    @Override
    public String getGroupSuffix(String world, String group) {
        return this.getGroupInfoString(world, group, "suffix", "");
    }

    @Override
    public void setGroupSuffix(String world, String group, String suffix) {
        this.setGroupInfoString(world, group, "prefix", suffix);
    }

    @Override
    public int getPlayerInfoInteger(String world, String player, String node, int defaultValue) {
        String s = this.getPlayerInfoString(world, player, node, null);
        if (s == null) {
            return defaultValue;
        }
        try {
            return Integer.valueOf(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public void setPlayerInfoInteger(String world, String player, String node, int value) {
        this.setPlayerInfoString(world, player, node, String.valueOf(value));
    }

    @Override
    public int getGroupInfoInteger(String world, String group, String node, int defaultValue) {
        String s = this.getGroupInfoString(world, group, node, null);
        if (s == null) {
            return defaultValue;
        }
        try {
            return Integer.valueOf(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public void setGroupInfoInteger(String world, String group, String node, int value) {
        this.setGroupInfoString(world, group, node, String.valueOf(value));
    }

    @Override
    public double getPlayerInfoDouble(String world, String player, String node, double defaultValue) {
        String s = this.getPlayerInfoString(world, player, node, null);
        if (s == null) {
            return defaultValue;
        }
        try {
            return Double.valueOf(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public void setPlayerInfoDouble(String world, String player, String node, double value) {
        this.setPlayerInfoString(world, player, node, String.valueOf(value));
    }

    @Override
    public double getGroupInfoDouble(String world, String group, String node, double defaultValue) {
        String s = this.getGroupInfoString(world, group, node, null);
        if (s == null) {
            return defaultValue;
        }
        try {
            return Double.valueOf(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public void setGroupInfoDouble(String world, String group, String node, double value) {
        this.setGroupInfoString(world, group, node, String.valueOf(value));
    }

    @Override
    public boolean getPlayerInfoBoolean(String world, String player, String node, boolean defaultValue) {
        String s = this.getPlayerInfoString(world, player, node, null);
        if (s == null) {
            return defaultValue;
        }
        Boolean val = Boolean.valueOf(s);
        return val != null ? val : defaultValue;
    }

    @Override
    public void setPlayerInfoBoolean(String world, String player, String node, boolean value) {
        this.setPlayerInfoString(world, player, node, String.valueOf(value));
    }

    @Override
    public boolean getGroupInfoBoolean(String world, String group, String node, boolean defaultValue) {
        String s = this.getGroupInfoString(world, group, node, null);
        if (s == null) {
            return defaultValue;
        }
        return Boolean.valueOf(s);
    }

    @Override
    public void setGroupInfoBoolean(String world, String group, String node, boolean value) {
        this.setGroupInfoString(world, group, node, String.valueOf(value));
    }

    @Override
    public String getPlayerInfoString(String world, String playerName, String node, String defaultValue) {
        Player p = Bukkit.getPlayerExact((String)playerName);
        String ret = null;
        if (p != null) {
            ret = this.overPerms.getPlayerPermissions(p).getStringMeta(node, defaultValue);
        } else {
            int playerId = this.overPerms.getSQLManager().getPlayerId(playerName);
            int worldId = this.overPerms.getSQLManager().getWorldId(world);
            ret = this.overPerms.getSQLManager().getPlayerMetaValue(playerId, worldId, node);
        }
        if (ret == null) {
            return defaultValue;
        }
        return ret;
    }

    @Override
    public void setPlayerInfoString(String world, String player, String node, String value) {
        Player p = Bukkit.getPlayerExact((String)player);
        int playerId = this.overPerms.getSQLManager().getPlayerId(player, true);
        int worldId = this.overPerms.getSQLManager().getWorldId(player, false);
        if (worldId < 0) {
            this.overPerms.getSQLManager().setGlobalPlayerMeta(playerId, node, value);
        } else {
            this.overPerms.getSQLManager().setPlayerMeta(playerId, worldId, node, value);
        }
        if (p != null) {
            this.overPerms.getPlayerPermissions(p).recalculateMeta();
        }
    }

    @Override
    public String getGroupInfoString(String world, String groupName, String node, String defaultValue) {
        Group group = this.overPerms.getGroupManager().getGroup(groupName);
        if (group == null) {
            return defaultValue;
        }
        String value = group.getMeta(node);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    @Override
    public void setGroupInfoString(String world, String groupName, String node, String value) {
        Group group = this.overPerms.getGroupManager().getGroup(groupName);
        if (group == null) {
            return;
        }
        group.setMeta(node, value);
        group.recalculatePermissions();
    }

    public class PermissionServerListener
    implements Listener {
        Chat_OverPermissions chat = null;

        public PermissionServerListener(Chat_OverPermissions chat) {
            this.chat = chat;
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginEnable(PluginEnableEvent event) {
            Plugin chat;
            if (this.chat.overPerms == null && (chat = Chat_OverPermissions.this.plugin.getServer().getPluginManager().getPlugin("OverPermissions")) != null) {
                this.chat.overPerms = (OverPermissions)chat;
                Chat_OverPermissions.this.plugin.getLogger().info(String.format("[%s][Chat] %s hooked.", Chat_OverPermissions.this.plugin.getDescription().getName(), Chat_OverPermissions.this.getName()));
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginDisable(PluginDisableEvent event) {
            if (this.chat.overPerms != null && event.getPlugin().getDescription().getName().equals("OverPermissions")) {
                this.chat.overPerms = null;
                Chat_OverPermissions.this.plugin.getLogger().info(String.format("[%s][Chat] %s un-hooked.", Chat_OverPermissions.this.plugin.getDescription().getName(), Chat_OverPermissions.this.getName()));
            }
        }
    }
}

