/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault.permission.plugins;

import com.overmc.overpermissions.OverPermissions;
import com.overmc.overpermissions.OverPermissionsAPI;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;

public class Permission_OverPermissions
extends Permission {
    private final String name = "OverPermissions";
    private OverPermissions overPerms;
    private OverPermissionsAPI api;

    public Permission_OverPermissions(Plugin plugin) {
        Plugin perms;
        this.plugin = plugin;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new PermissionServerListener(this), plugin);
        if (this.overPerms == null && (perms = plugin.getServer().getPluginManager().getPlugin("OverPermissions")) != null && perms.isEnabled()) {
            this.overPerms = (OverPermissions)perms;
            log.info(String.format("[%s][Permission] %s hooked.", plugin.getDescription().getName(), "OverPermissions"));
        }
        if (this.api == null && this.overPerms != null) {
            this.api = this.overPerms.getAPI();
        }
    }

    @Override
    public String getName() {
        return "OverPermissions";
    }

    @Override
    public boolean isEnabled() {
        return this.overPerms != null && this.overPerms.isEnabled();
    }

    @Override
    public boolean playerHas(String worldName, String playerName, String permission) {
        return this.api.playerHas(worldName, playerName, permission);
    }

    @Override
    public boolean playerAdd(String worldName, String playerName, String permission) {
        return this.api.playerAdd(worldName, playerName, permission);
    }

    @Override
    public boolean playerRemove(String worldName, String playerName, String permission) {
        return this.api.playerRemove(worldName, playerName, permission);
    }

    @Override
    public boolean groupHas(String worldName, String groupName, String permission) {
        return this.api.groupHas(groupName, permission);
    }

    @Override
    public boolean groupAdd(String worldName, String groupName, String permission) {
        return this.api.groupAdd(groupName, permission);
    }

    @Override
    public boolean groupRemove(String worldName, String groupName, String permission) {
        return this.api.groupRemove(groupName, permission);
    }

    @Override
    public boolean playerInGroup(String worldName, String playerName, String groupName) {
        return this.api.groupHasPlayer(playerName, groupName);
    }

    @Override
    public boolean playerAddGroup(String worldName, String playerName, String groupName) {
        return this.api.playerAddGroup(playerName, groupName);
    }

    @Override
    public boolean playerRemoveGroup(String worldName, String playerName, String groupName) {
        return this.api.playerRemoveGroup(playerName, groupName);
    }

    @Override
    public String[] getPlayerGroups(String worldName, String playerName) {
        return this.api.getPlayerGroups(worldName, playerName);
    }

    @Override
    public String getPrimaryGroup(String worldName, String playerName) {
        String[] playerGroups = this.getPlayerGroups(worldName, playerName);
        if (playerGroups.length == 0) {
            return null;
        }
        return playerGroups[0];
    }

    @Override
    public boolean playerAddTransient(String world, String player, String permission) {
        return this.api.playerAddTransient(world, player, permission);
    }

    @Override
    public boolean playerRemoveTransient(String world, String player, String permission) {
        return this.api.playerRemoveTransient(world, player, permission);
    }

    @Override
    public String[] getGroups() {
        return this.api.getGroupsArray();
    }

    @Override
    public boolean hasSuperPermsCompat() {
        return true;
    }

    @Override
    public boolean hasGroupSupport() {
        return true;
    }

    public class PermissionServerListener
    implements Listener {
        Permission_OverPermissions permission = null;

        public PermissionServerListener(Permission_OverPermissions permission) {
            this.permission = permission;
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginEnable(PluginEnableEvent event) {
            Plugin perms;
            if (this.permission.overPerms == null && (perms = Permission_OverPermissions.this.plugin.getServer().getPluginManager().getPlugin("OverPermissions")) != null) {
                this.permission.overPerms = (OverPermissions)perms;
                log.info(String.format("[%s][Permission] %s hooked.", Permission_OverPermissions.this.plugin.getDescription().getName(), "OverPermissions"));
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginDisable(PluginDisableEvent event) {
            if (this.permission.overPerms != null && event.getPlugin().getDescription().getName().equals("OverPermissions")) {
                this.permission.overPerms = null;
                log.info(String.format("[%s][Permission] %s un-hooked.", Permission_OverPermissions.this.plugin.getDescription().getName(), "OverPermissions"));
            }
        }
    }
}

