/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault.permission.plugins;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;
import org.tyrannyofheaven.bukkit.zPermissions.ZPermissionsService;

public class Permission_zPermissions
extends Permission {
    private static final String PRIMARY_GROUP_TRACK_METADATA_KEY = "Vault.primary-group.track";
    private final String name = "zPermissions";
    private ZPermissionsService service;
    private boolean trackSupport;

    public Permission_zPermissions(Plugin plugin) {
        this.plugin = plugin;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new PermissionServerListener(), plugin);
        if (this.service == null) {
            this.service = (ZPermissionsService)plugin.getServer().getServicesManager().load(ZPermissionsService.class);
            if (this.service != null) {
                log.info(String.format("[%s][Permission] %s hooked.", plugin.getDescription().getName(), "zPermissions"));
                this.detectTrackMethods();
            }
        }
    }

    @Override
    public String getName() {
        return "zPermissions";
    }

    @Override
    public boolean isEnabled() {
        return this.service != null;
    }

    @Override
    public boolean hasSuperPermsCompat() {
        return true;
    }

    @Override
    public boolean playerHas(String world, String player, String permission) {
        Player p = Bukkit.getServer().getPlayer(player);
        if (p == null) {
            Map perms = this.service.getPlayerPermissions(world, null, player);
            Boolean value = (Boolean)perms.get(permission.toLowerCase());
            if (value != null) {
                return value;
            }
            org.bukkit.permissions.Permission perm = Bukkit.getPluginManager().getPermission(permission);
            if (perm != null) {
                OfflinePlayer op = Bukkit.getServer().getOfflinePlayer(player);
                return perm.getDefault().getValue(op != null ? op.isOp() : false);
            }
            return false;
        }
        return this.playerHas(p, permission);
    }

    @Override
    public boolean playerAdd(String world, String player, String permission) {
        if (world != null) {
            permission = world + ":" + permission;
        }
        return this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), "permissions player " + player + " set " + permission);
    }

    @Override
    public boolean playerRemove(String world, String player, String permission) {
        if (world != null) {
            permission = world + ":" + permission;
        }
        return this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), "permissions player " + player + " unset " + permission);
    }

    @Override
    public boolean groupHas(String world, String group, String permission) {
        Map perms = this.service.getGroupPermissions(world, null, group);
        Boolean value = (Boolean)perms.get(permission.toLowerCase());
        if (value != null) {
            return value;
        }
        org.bukkit.permissions.Permission perm = Bukkit.getPluginManager().getPermission(permission);
        if (perm != null) {
            return perm.getDefault().getValue(false);
        }
        return false;
    }

    @Override
    public boolean groupAdd(String world, String group, String permission) {
        if (world != null) {
            permission = world + ":" + permission;
        }
        return this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), "permissions group " + group + " set " + permission);
    }

    @Override
    public boolean groupRemove(String world, String group, String permission) {
        if (world != null) {
            permission = world + ":" + permission;
        }
        return this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), "permissions group " + group + " unset " + permission);
    }

    @Override
    public boolean playerInGroup(String world, String player, String group) {
        Set groups = this.service.getPlayerGroups(player);
        for (String g : groups) {
            if (!g.equalsIgnoreCase(group)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean playerAddGroup(String world, String player, String group) {
        return this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), "permissions group " + group + " add " + player);
    }

    @Override
    public boolean playerRemoveGroup(String world, String player, String group) {
        return this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), "permissions group " + group + " remove " + player);
    }

    @Override
    public String[] getPlayerGroups(String world, String player) {
        return this.service.getPlayerGroups(player).toArray(new String[0]);
    }

    @Override
    public String getPrimaryGroup(String world, String player) {
        try {
            String track;
            if (this.trackSupport && (track = (String)this.service.getPlayerMetadata(player, PRIMARY_GROUP_TRACK_METADATA_KEY, String.class)) != null && !"".equals(track)) {
                List groups = this.service.getTrackGroups(track);
                Collections.reverse(groups);
                LinkedHashSet trackGroups = new LinkedHashSet(groups);
                trackGroups.retainAll(this.service.getPlayerAssignedGroups(player));
                if (!trackGroups.isEmpty()) {
                    return (String)trackGroups.iterator().next();
                }
            }
        }
        catch (IllegalStateException e) {
            log.warning("Bad property 'Vault.primary-group.track' for " + player + "; is it a string and does the track exist?");
        }
        List groups = this.service.getPlayerAssignedGroups(player);
        if (!groups.isEmpty()) {
            return (String)groups.get(0);
        }
        return null;
    }

    @Override
    public String[] getGroups() {
        return this.service.getAllGroups().toArray(new String[0]);
    }

    @Override
    public boolean hasGroupSupport() {
        return true;
    }

    private void detectTrackMethods() {
        try {
            this.service.getClass().getMethod("getTrackGroups", String.class);
            this.trackSupport = true;
        }
        catch (SecurityException e) {
            this.trackSupport = false;
        }
        catch (NoSuchMethodException e) {
            this.trackSupport = false;
        }
    }

    public class PermissionServerListener
    implements Listener {
        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginEnable(PluginEnableEvent event) {
            if (Permission_zPermissions.this.service == null && event.getPlugin().getDescription().getName().equals("zPermissions")) {
                Permission_zPermissions.this.service = (ZPermissionsService)Permission_zPermissions.this.plugin.getServer().getServicesManager().load(ZPermissionsService.class);
                if (Permission_zPermissions.this.service != null) {
                    log.info(String.format("[%s][Permission] %s hooked.", Permission_zPermissions.this.plugin.getDescription().getName(), "zPermissions"));
                    Permission_zPermissions.this.detectTrackMethods();
                }
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginDisable(PluginDisableEvent event) {
            if (Permission_zPermissions.this.service != null && event.getPlugin().getDescription().getName().equals("zPermissions")) {
                Permission_zPermissions.this.service = null;
                log.info(String.format("[%s][Permission] %s un-hooked.", Permission_zPermissions.this.plugin.getDescription().getName(), "zPermissions"));
            }
        }
    }
}

