/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault.permission.plugins;

import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;
import ru.tehkode.permissions.PermissionGroup;
import ru.tehkode.permissions.PermissionUser;
import ru.tehkode.permissions.bukkit.PermissionsEx;

public class Permission_PermissionsEx
extends Permission {
    private final String name = "PermissionsEx";
    private PermissionsEx permission = null;

    public Permission_PermissionsEx(Plugin plugin) {
        Plugin perms;
        this.plugin = plugin;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new PermissionServerListener(this), plugin);
        if (this.permission == null && (perms = plugin.getServer().getPluginManager().getPlugin("PermissionsEx")) != null && perms.isEnabled()) {
            try {
                if (Double.valueOf(perms.getDescription().getVersion()) < 1.16) {
                    log.info(String.format("[%s][Permission] %s below 1.16 is not compatible with Vault! Falling back to SuperPerms only mode. PLEASE UPDATE!", plugin.getDescription().getName(), "PermissionsEx"));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.permission = (PermissionsEx)perms;
            log.info(String.format("[%s][Permission] %s hooked.", plugin.getDescription().getName(), "PermissionsEx"));
        }
    }

    @Override
    public boolean isEnabled() {
        if (this.permission == null) {
            return false;
        }
        return this.permission.isEnabled();
    }

    @Override
    public boolean playerInGroup(String worldName, String playerName, String groupName) {
        return PermissionsEx.getPermissionManager().getUser(playerName).inGroup(groupName);
    }

    @Override
    public String getName() {
        return "PermissionsEx";
    }

    @Override
    public boolean playerAddGroup(String worldName, String playerName, String groupName) {
        PermissionGroup group = PermissionsEx.getPermissionManager().getGroup(groupName);
        PermissionUser user = PermissionsEx.getPermissionManager().getUser(playerName);
        if (group == null || user == null) {
            return false;
        }
        user.addGroup(groupName, worldName);
        return true;
    }

    @Override
    public boolean playerRemoveGroup(String worldName, String playerName, String groupName) {
        PermissionsEx.getPermissionManager().getUser(playerName).removeGroup(groupName, worldName);
        return true;
    }

    @Override
    public boolean playerAdd(String worldName, String playerName, String permission) {
        PermissionUser user = PermissionsEx.getPermissionManager().getUser(playerName);
        if (user == null) {
            return false;
        }
        user.addPermission(permission, worldName);
        return true;
    }

    @Override
    public boolean playerRemove(String worldName, String playerName, String permission) {
        PermissionUser user = PermissionsEx.getPermissionManager().getUser(playerName);
        if (user == null) {
            return false;
        }
        user.removePermission(permission, worldName);
        return true;
    }

    @Override
    public boolean groupAdd(String worldName, String groupName, String permission) {
        PermissionGroup group = PermissionsEx.getPermissionManager().getGroup(groupName);
        if (group == null) {
            return false;
        }
        group.addPermission(permission, worldName);
        return true;
    }

    @Override
    public boolean groupRemove(String worldName, String groupName, String permission) {
        PermissionGroup group = PermissionsEx.getPermissionManager().getGroup(groupName);
        if (group == null) {
            return false;
        }
        group.removePermission(permission, worldName);
        return true;
    }

    @Override
    public boolean groupHas(String worldName, String groupName, String permission) {
        PermissionGroup group = PermissionsEx.getPermissionManager().getGroup(groupName);
        if (group == null) {
            return false;
        }
        return group.has(permission, worldName);
    }

    @Override
    public String[] getPlayerGroups(String world, String playerName) {
        return PermissionsEx.getPermissionManager().getUser(playerName).getGroupsNames();
    }

    @Override
    public String getPrimaryGroup(String world, String playerName) {
        PermissionUser user = PermissionsEx.getPermissionManager().getUser(playerName);
        if (user == null) {
            return null;
        }
        if (user.getGroupsNames(world).length > 0) {
            return user.getGroupsNames(world)[0];
        }
        return null;
    }

    @Override
    public boolean playerHas(String worldName, String playerName, String permission) {
        PermissionUser user = PermissionsEx.getPermissionManager().getUser(playerName);
        if (user != null) {
            return user.has(permission, worldName);
        }
        return false;
    }

    @Override
    public boolean playerAddTransient(String worldName, String player, String permission) {
        PermissionUser pPlayer = PermissionsEx.getPermissionManager().getUser(player);
        if (pPlayer != null) {
            pPlayer.addTimedPermission(permission, worldName, 0);
            return true;
        }
        return false;
    }

    @Override
    public boolean playerAddTransient(String worldName, Player player, String permission) {
        return this.playerAddTransient(worldName, player.getName(), permission);
    }

    @Override
    public boolean playerAddTransient(String player, String permission) {
        return this.playerAddTransient(null, player, permission);
    }

    @Override
    public boolean playerAddTransient(Player player, String permission) {
        return this.playerAddTransient(null, player.getName(), permission);
    }

    @Override
    public boolean playerRemoveTransient(String worldName, String player, String permission) {
        PermissionUser pPlayer = PermissionsEx.getPermissionManager().getUser(player);
        if (pPlayer != null) {
            pPlayer.removeTimedPermission(permission, worldName);
            return true;
        }
        return false;
    }

    @Override
    public boolean playerRemoveTransient(Player player, String permission) {
        return this.playerRemoveTransient(null, player.getName(), permission);
    }

    @Override
    public boolean playerRemoveTransient(String worldName, Player player, String permission) {
        return this.playerRemoveTransient(worldName, player.getName(), permission);
    }

    @Override
    public boolean playerRemoveTransient(String player, String permission) {
        return this.playerRemoveTransient(null, player, permission);
    }

    @Override
    public String[] getGroups() {
        PermissionGroup[] groups = PermissionsEx.getPermissionManager().getGroups();
        if (groups == null || groups.length == 0) {
            return null;
        }
        String[] groupNames = new String[groups.length];
        for (int i = 0; i < groups.length; ++i) {
            groupNames[i] = groups[i].getName();
        }
        return groupNames;
    }

    @Override
    public boolean hasSuperPermsCompat() {
        return true;
    }

    @Override
    public boolean hasGroupSupport() {
        return true;
    }

    public class PermissionServerListener
    implements Listener {
        Permission_PermissionsEx permission = null;

        public PermissionServerListener(Permission_PermissionsEx permission) {
            this.permission = permission;
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginEnable(PluginEnableEvent event) {
            Plugin perms;
            if (this.permission.permission == null && (perms = event.getPlugin()).getDescription().getName().equals("PermissionsEx")) {
                try {
                    if (Double.valueOf(perms.getDescription().getVersion()) < 1.16) {
                        log.info(String.format("[%s][Permission] %s below 1.16 is not compatible with Vault! Falling back to SuperPerms only mode. PLEASE UPDATE!", Permission_PermissionsEx.this.plugin.getDescription().getName(), "PermissionsEx"));
                        return;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.permission.permission = (PermissionsEx)perms;
                log.info(String.format("[%s][Permission] %s hooked.", Permission_PermissionsEx.this.plugin.getDescription().getName(), "PermissionsEx"));
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginDisable(PluginDisableEvent event) {
            if (this.permission.permission != null && event.getPlugin().getDescription().getName().equals("PermissionsEx")) {
                this.permission.permission = null;
                log.info(String.format("[%s][Permission] %s un-hooked.", Permission_PermissionsEx.this.plugin.getDescription().getName(), "PermissionsEx"));
            }
        }
    }
}

