/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault.economy.plugins;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import net.teamalpha.taecon.TAEcon;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;

public class Economy_TAEcon
implements Economy {
    private static final Logger log = Logger.getLogger("Minecraft");
    private final String name = "TAEcon";
    private Plugin plugin = null;
    private TAEcon economy = null;

    public Economy_TAEcon(Plugin plugin) {
        Plugin taecon;
        this.plugin = plugin;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new EconomyServerListener(this), plugin);
        if (this.economy == null && (taecon = plugin.getServer().getPluginManager().getPlugin("TAEcon")) != null && taecon.isEnabled()) {
            this.economy = (TAEcon)taecon;
            log.info(String.format("[%s][Economy] %s hooked.", plugin.getDescription().getName(), "TAEcon"));
        }
    }

    @Override
    public boolean isEnabled() {
        return this.economy != null;
    }

    @Override
    public String getName() {
        return "TAEcon";
    }

    @Override
    public boolean hasBankSupport() {
        return false;
    }

    @Override
    public int fractionalDigits() {
        return 0;
    }

    @Override
    public String format(double amount) {
        if ((amount = Math.ceil(amount)) == 1.0) {
            return String.format("%d %s", (int)amount, this.currencyNameSingular());
        }
        return String.format("%d %s", (int)amount, this.currencyNamePlural());
    }

    @Override
    public String currencyNamePlural() {
        return this.economy.getCurrencyName(Boolean.valueOf(true));
    }

    @Override
    public String currencyNameSingular() {
        return this.economy.getCurrencyName(Boolean.valueOf(false));
    }

    @Override
    public boolean hasAccount(String playerName) {
        return true;
    }

    @Override
    public double getBalance(String playerName) {
        return this.economy.getBalance(playerName);
    }

    @Override
    public boolean has(String playerName, double amount) {
        return this.getBalance(playerName) >= amount;
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        String message;
        EconomyResponse.ResponseType rt;
        int iamount = (int)Math.ceil(amount);
        if (this.has(playerName, amount)) {
            if (this.economy.removeBalance(playerName, iamount).booleanValue()) {
                rt = EconomyResponse.ResponseType.SUCCESS;
                message = null;
            } else {
                rt = EconomyResponse.ResponseType.SUCCESS;
                message = "ERROR";
            }
        } else {
            rt = EconomyResponse.ResponseType.FAILURE;
            message = "Not enough money";
        }
        return new EconomyResponse(iamount, this.getBalance(playerName), rt, message);
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, double amount) {
        String message;
        EconomyResponse.ResponseType rt;
        int iamount = (int)Math.floor(amount);
        if (this.economy.addBalance(playerName, iamount).booleanValue()) {
            rt = EconomyResponse.ResponseType.SUCCESS;
            message = null;
        } else {
            rt = EconomyResponse.ResponseType.SUCCESS;
            message = "ERROR";
        }
        return new EconomyResponse(iamount, this.getBalance(playerName), rt, message);
    }

    @Override
    public EconomyResponse createBank(String name, String player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "TAEcon does not support bank accounts");
    }

    @Override
    public EconomyResponse deleteBank(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "TAEcon does not support bank accounts");
    }

    @Override
    public EconomyResponse bankBalance(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "TAEcon does not support bank accounts");
    }

    @Override
    public EconomyResponse bankHas(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "TAEcon does not support bank accounts");
    }

    @Override
    public EconomyResponse bankWithdraw(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "TAEcon does not support bank accounts");
    }

    @Override
    public EconomyResponse bankDeposit(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "TAEcon does not support bank accounts");
    }

    @Override
    public EconomyResponse isBankOwner(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "TAEcon does not support bank accounts");
    }

    @Override
    public EconomyResponse isBankMember(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "TAEcon does not support bank accounts");
    }

    @Override
    public List<String> getBanks() {
        return new ArrayList<String>();
    }

    @Override
    public boolean createPlayerAccount(String playerName) {
        return false;
    }

    @Override
    public boolean hasAccount(String playerName, String worldName) {
        return true;
    }

    @Override
    public double getBalance(String playerName, String world) {
        return this.getBalance(playerName);
    }

    @Override
    public boolean has(String playerName, String worldName, double amount) {
        return this.has(playerName, amount);
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, String worldName, double amount) {
        return this.withdrawPlayer(playerName, amount);
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, String worldName, double amount) {
        return this.depositPlayer(playerName, amount);
    }

    @Override
    public boolean createPlayerAccount(String playerName, String worldName) {
        return false;
    }

    public class EconomyServerListener
    implements Listener {
        Economy_TAEcon economy = null;

        public EconomyServerListener(Economy_TAEcon economy) {
            this.economy = economy;
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginEnable(PluginEnableEvent event) {
            Plugin taecon;
            if (this.economy.economy == null && (taecon = event.getPlugin()).getDescription().getName().equals("TAEcon")) {
                this.economy.economy = (TAEcon)taecon;
                log.info(String.format("[%s][Economy] %s hooked.", Economy_TAEcon.this.plugin.getDescription().getName(), "TAEcon"));
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginDisable(PluginDisableEvent event) {
            if (this.economy.economy != null && event.getPlugin().getDescription().getName().equals("TAEcon")) {
                this.economy.economy = null;
                log.info(String.format("[%s][Economy] %s unhooked.", Economy_TAEcon.this.plugin.getDescription().getName(), "TAEcon"));
            }
        }
    }
}

