/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault.economy.plugins;

import cosine.boseconomy.BOSEconomy;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;

public class Economy_BOSE6
implements Economy {
    private static final Logger log = Logger.getLogger("Minecraft");
    private final String name = "BOSEconomy";
    private Plugin plugin = null;
    private BOSEconomy economy = null;

    public Economy_BOSE6(Plugin plugin) {
        Plugin bose;
        this.plugin = plugin;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new EconomyServerListener(this), plugin);
        log.log(Level.SEVERE, "BOSEconomy6 is an extremely outdated plugin and can not be used reliably for economy! You should update the more recent and maintained BOSEconomy7 for compatibility!");
        if (this.economy == null && (bose = plugin.getServer().getPluginManager().getPlugin("BOSEconomy")) != null && bose.isEnabled() && bose.getDescription().getVersion().startsWith("0.6")) {
            this.economy = (BOSEconomy)bose;
            log.info(String.format("[%s][Economy] %s hooked.", plugin.getDescription().getName(), "BOSEconomy"));
        }
    }

    @Override
    public String getName() {
        return "BOSEconomy";
    }

    @Override
    public boolean isEnabled() {
        if (this.economy == null) {
            return false;
        }
        return this.economy.isEnabled();
    }

    @Override
    public double getBalance(String playerName) {
        return this.economy.getPlayerMoney(playerName);
    }

    @Override
    public boolean has(String playerName, double amount) {
        return this.getBalance(playerName) >= amount;
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        String errorMessage = null;
        if (amount < 0.0) {
            errorMessage = "Cannot withdraw negative funds";
            EconomyResponse.ResponseType type = EconomyResponse.ResponseType.FAILURE;
            amount = 0.0;
            double balance = this.economy.getPlayerMoney(playerName);
            return new EconomyResponse(balance, balance, type, errorMessage);
        }
        amount = Math.ceil(amount);
        double balance = this.economy.getPlayerMoney(playerName);
        if (balance - amount < 0.0) {
            errorMessage = "Insufficient funds";
            EconomyResponse.ResponseType type = EconomyResponse.ResponseType.FAILURE;
            amount = 0.0;
            return new EconomyResponse(balance, balance, type, errorMessage);
        }
        if (this.economy.setPlayerMoney(playerName, (int)(balance - amount), false)) {
            EconomyResponse.ResponseType type = EconomyResponse.ResponseType.SUCCESS;
            balance = this.economy.getPlayerMoney(playerName);
            return new EconomyResponse(amount, balance, type, errorMessage);
        }
        errorMessage = "Error withdrawing funds";
        EconomyResponse.ResponseType type = EconomyResponse.ResponseType.FAILURE;
        amount = 0.0;
        balance = this.economy.getPlayerMoney(playerName);
        return new EconomyResponse(amount, balance, type, errorMessage);
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, double amount) {
        String errorMessage = null;
        if (amount < 0.0) {
            errorMessage = "Cannot deposit negative funds";
            EconomyResponse.ResponseType type = EconomyResponse.ResponseType.FAILURE;
            amount = 0.0;
            double balance = this.economy.getPlayerMoney(playerName);
            return new EconomyResponse(balance, balance, type, errorMessage);
        }
        amount = Math.ceil(amount);
        double balance = this.economy.getPlayerMoney(playerName);
        if (this.economy.setPlayerMoney(playerName, (int)(balance + amount), false)) {
            EconomyResponse.ResponseType type = EconomyResponse.ResponseType.SUCCESS;
            balance = this.economy.getPlayerMoney(playerName);
            return new EconomyResponse(amount, balance, type, errorMessage);
        }
        errorMessage = "Error withdrawing funds";
        EconomyResponse.ResponseType type = EconomyResponse.ResponseType.FAILURE;
        amount = 0.0;
        balance = this.economy.getPlayerMoney(playerName);
        return new EconomyResponse(balance, balance, type, errorMessage);
    }

    @Override
    public String currencyNamePlural() {
        return this.economy.getMoneyNamePlural();
    }

    @Override
    public String currencyNameSingular() {
        return this.economy.getMoneyName();
    }

    @Override
    public String format(double amount) {
        if (amount == 1.0) {
            return String.format("%.0f %s", amount, this.currencyNameSingular());
        }
        return String.format("%.2f %s", amount, this.currencyNamePlural());
    }

    @Override
    public EconomyResponse createBank(String name, String player) {
        boolean success = this.economy.addBankOwner(name, player, false);
        if (success) {
            return new EconomyResponse(0.0, this.economy.getBankMoney(name), EconomyResponse.ResponseType.SUCCESS, "");
        }
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Unable to create that bank account.");
    }

    @Override
    public EconomyResponse deleteBank(String name) {
        boolean success = this.economy.removeBank(name);
        if (success) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.SUCCESS, "");
        }
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Unable to remove that bank account.");
    }

    @Override
    public EconomyResponse bankHas(String name, double amount) {
        if (!this.economy.bankExists(name)) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "That bank does not exist!");
        }
        double bankMoney = this.economy.getBankMoney(name);
        if (bankMoney < amount) {
            return new EconomyResponse(0.0, bankMoney, EconomyResponse.ResponseType.FAILURE, "The bank does not have enough money!");
        }
        return new EconomyResponse(0.0, bankMoney, EconomyResponse.ResponseType.SUCCESS, "");
    }

    @Override
    public EconomyResponse bankWithdraw(String name, double amount) {
        EconomyResponse er = this.bankHas(name, amount);
        if (!er.transactionSuccess()) {
            return er;
        }
        this.economy.addBankMoney(name, (int)(-amount), true);
        return new EconomyResponse((int)amount, this.economy.getBankMoney(name), EconomyResponse.ResponseType.SUCCESS, "");
    }

    @Override
    public EconomyResponse bankDeposit(String name, double amount) {
        if (!this.economy.bankExists(name)) {
            return new EconomyResponse(amount, 0.0, EconomyResponse.ResponseType.FAILURE, "That bank does not exist!");
        }
        this.economy.addBankMoney(name, (int)amount, true);
        return new EconomyResponse((int)amount, this.economy.getBankMoney(name), EconomyResponse.ResponseType.SUCCESS, "");
    }

    @Override
    public EconomyResponse isBankOwner(String name, String playerName) {
        if (!this.economy.bankExists(name)) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "That bank does not exist!");
        }
        if (this.economy.isBankOwner(name, playerName)) {
            return new EconomyResponse(0.0, this.economy.getBankMoney(name), EconomyResponse.ResponseType.SUCCESS, "");
        }
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "That player is not a bank owner!");
    }

    @Override
    public EconomyResponse isBankMember(String name, String playerName) {
        if (!this.economy.bankExists(name)) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "That bank does not exist!");
        }
        if (this.economy.isBankMember(name, playerName)) {
            return new EconomyResponse(0.0, this.economy.getBankMoney(name), EconomyResponse.ResponseType.SUCCESS, "");
        }
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "That player is not a bank member!");
    }

    @Override
    public EconomyResponse bankBalance(String name) {
        if (!this.economy.bankExists(name)) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "That bank does not exist!");
        }
        double bankMoney = this.economy.getBankMoney(name);
        return new EconomyResponse(0.0, bankMoney, EconomyResponse.ResponseType.SUCCESS, null);
    }

    @Override
    public List<String> getBanks() {
        return this.economy.getBankList();
    }

    @Override
    public boolean hasBankSupport() {
        return true;
    }

    @Override
    public boolean hasAccount(String playerName) {
        return this.economy.playerRegistered(playerName, false);
    }

    @Override
    public boolean createPlayerAccount(String playerName) {
        if (this.economy.playerRegistered(playerName, false)) {
            return false;
        }
        return this.economy.registerPlayer(playerName);
    }

    @Override
    public int fractionalDigits() {
        return 0;
    }

    @Override
    public boolean hasAccount(String playerName, String worldName) {
        return this.hasAccount(playerName);
    }

    @Override
    public double getBalance(String playerName, String world) {
        return this.getBalance(playerName);
    }

    @Override
    public boolean has(String playerName, String worldName, double amount) {
        return this.has(playerName, amount);
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, String worldName, double amount) {
        return this.withdrawPlayer(playerName, amount);
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, String worldName, double amount) {
        return this.depositPlayer(playerName, amount);
    }

    @Override
    public boolean createPlayerAccount(String playerName, String worldName) {
        return this.createPlayerAccount(playerName);
    }

    public class EconomyServerListener
    implements Listener {
        Economy_BOSE6 economy = null;

        public EconomyServerListener(Economy_BOSE6 economy) {
            this.economy = economy;
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginEnable(PluginEnableEvent event) {
            Plugin bose;
            if (this.economy.economy == null && (bose = event.getPlugin()).getDescription().getName().equals("BOSEconomy") && bose.getDescription().getVersion().startsWith("0.6")) {
                this.economy.economy = (BOSEconomy)bose;
                log.info(String.format("[%s][Economy] %s hooked.", Economy_BOSE6.this.plugin.getDescription().getName(), "BOSEconomy"));
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginDisable(PluginDisableEvent event) {
            if (this.economy.economy != null && event.getPlugin().getDescription().getName().equals("BOSEconomy") && event.getPlugin().getDescription().getVersion().startsWith("0.6")) {
                this.economy.economy = null;
                log.info(String.format("[%s][Economy] %s unhooked.", Economy_BOSE6.this.plugin.getDescription().getName(), "BOSEconomy"));
            }
        }
    }
}

