/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault.economy.plugins;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;
import org.neocraft.AEco.AEco;

public class Economy_AEco
implements Economy {
    private static final Logger log = Logger.getLogger("Minecraft");
    private final String name = "AEco";
    private Plugin plugin = null;
    private org.neocraft.AEco.part.Economy.Economy economy = null;
    private Method createWallet = null;

    public Economy_AEco(Plugin plugin) {
        Plugin econ;
        this.plugin = plugin;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new EconomyServerListener(this), plugin);
        log.log(Level.WARNING, "AEco is an integer only economy, you may notice inconsistencies with accounts if you do not setup your other econ using plugins accordingly!");
        if (this.economy == null && (econ = plugin.getServer().getPluginManager().getPlugin("AEco")) != null && econ.isEnabled()) {
            this.economy = AEco.ECONOMY;
            try {
                this.createWallet = this.economy.getClass().getMethod("createWallet", String.class);
                this.createWallet.setAccessible(true);
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            log.info(String.format("[%s][Economy] %s hooked.", plugin.getDescription().getName(), "AEco"));
        }
    }

    @Override
    public String getName() {
        return "AEco";
    }

    @Override
    public boolean isEnabled() {
        return this.economy != null;
    }

    @Override
    public double getBalance(String playerName) {
        return this.economy.cash(playerName);
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        if (amount < 0.0) {
            return new EconomyResponse(0.0, this.getBalance(playerName), EconomyResponse.ResponseType.FAILURE, "Cannot withdraw negative funds");
        }
        amount = Math.ceil(amount);
        int balance = this.economy.cash(playerName);
        if ((double)balance - amount < 0.0) {
            return new EconomyResponse(0.0, balance, EconomyResponse.ResponseType.FAILURE, "Insufficient funds");
        }
        this.economy.remove(playerName, (int)((double)balance - amount));
        balance = this.economy.cash(playerName);
        return new EconomyResponse(amount, balance, EconomyResponse.ResponseType.SUCCESS, "");
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, double amount) {
        if (amount < 0.0) {
            return new EconomyResponse(0.0, this.getBalance(playerName), EconomyResponse.ResponseType.FAILURE, "Cannot deposit negative funds");
        }
        amount = Math.ceil(amount);
        this.economy.add(playerName, (int)amount);
        return new EconomyResponse(amount, this.getBalance(playerName), EconomyResponse.ResponseType.SUCCESS, "");
    }

    @Override
    public String currencyNamePlural() {
        return "";
    }

    @Override
    public String currencyNameSingular() {
        return "";
    }

    @Override
    public String format(double amount) {
        if ((amount = Math.ceil(amount)) == 1.0) {
            return String.format("%d %s", (int)amount, this.currencyNameSingular());
        }
        return String.format("%d %s", (int)amount, this.currencyNamePlural());
    }

    @Override
    public EconomyResponse createBank(String name, String player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "AEco does not support bank accounts!");
    }

    @Override
    public EconomyResponse deleteBank(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "AEco does not support bank accounts!");
    }

    @Override
    public EconomyResponse bankHas(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "AEco does not support bank accounts!");
    }

    @Override
    public EconomyResponse bankWithdraw(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "AEco does not support bank accounts!");
    }

    @Override
    public EconomyResponse bankDeposit(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "AEco does not support bank accounts!");
    }

    @Override
    public boolean has(String playerName, double amount) {
        return this.getBalance(playerName) >= amount;
    }

    @Override
    public EconomyResponse isBankOwner(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "AEco does not support bank accounts!");
    }

    @Override
    public EconomyResponse isBankMember(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "AEco does not support bank accounts!");
    }

    @Override
    public EconomyResponse bankBalance(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "AEco does not support bank accounts!");
    }

    @Override
    public List<String> getBanks() {
        return new ArrayList<String>();
    }

    @Override
    public boolean hasBankSupport() {
        return false;
    }

    @Override
    public boolean hasAccount(String playerName) {
        return true;
    }

    @Override
    public boolean createPlayerAccount(String playerName) {
        try {
            return (Boolean)this.createWallet.invoke(this.economy.getClass(), playerName);
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public int fractionalDigits() {
        return 0;
    }

    @Override
    public boolean hasAccount(String playerName, String worldName) {
        return this.hasAccount(playerName);
    }

    @Override
    public double getBalance(String playerName, String world) {
        return this.getBalance(playerName);
    }

    @Override
    public boolean has(String playerName, String worldName, double amount) {
        return this.has(playerName, amount);
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, String worldName, double amount) {
        return this.withdrawPlayer(playerName, amount);
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, String worldName, double amount) {
        return this.depositPlayer(playerName, amount);
    }

    @Override
    public boolean createPlayerAccount(String playerName, String worldName) {
        return this.createPlayerAccount(playerName);
    }

    public class EconomyServerListener
    implements Listener {
        Economy_AEco economy = null;

        public EconomyServerListener(Economy_AEco economy) {
            this.economy = economy;
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginEnable(PluginEnableEvent event) {
            Plugin eco;
            if (this.economy.economy == null && (eco = event.getPlugin()).getDescription().getName().equals("AEco")) {
                this.economy.economy = AEco.ECONOMY;
                try {
                    Economy_AEco.this.createWallet = this.economy.getClass().getMethod("createWallet", String.class);
                    Economy_AEco.this.createWallet.setAccessible(true);
                }
                catch (SecurityException e) {
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                log.info(String.format("[%s][Economy] %s hooked.", Economy_AEco.this.plugin.getDescription().getName(), "AEco"));
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginDisable(PluginDisableEvent event) {
            if (this.economy.economy != null && event.getPlugin().getDescription().getName().equals("AEco")) {
                this.economy.economy = null;
                log.info(String.format("[%s][Economy] %s unhooked.", Economy_AEco.this.plugin.getDescription().getName(), "AEco"));
            }
        }
    }
}

