/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault.economy.plugins;

import com.nijiko.coelho.iConomy.iConomy;
import com.nijiko.coelho.iConomy.system.Account;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;

public class Economy_iConomy4
implements Economy {
    private static final Logger log = Logger.getLogger("Minecraft");
    private final String name = "iConomy 4";
    private Plugin plugin = null;
    protected iConomy economy = null;

    public Economy_iConomy4(Plugin plugin) {
        Plugin ec;
        this.plugin = plugin;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new EconomyServerListener(this), plugin);
        log.log(Level.SEVERE, "iConomy4 is an extremely outdated plugin and can not be used reliably for economy! You should update to the more recent and maintained iConomy6 for compatibility!");
        if (this.economy == null && (ec = plugin.getServer().getPluginManager().getPlugin("iConomy")) != null && ec.isEnabled() && ec.getClass().getName().equals("com.nijiko.coelho.iConomy.iConomy.class")) {
            this.economy = (iConomy)ec;
            log.info(String.format("[%s][Economy] %s hooked.", plugin.getDescription().getName(), "iConomy 4"));
        }
    }

    @Override
    public boolean isEnabled() {
        if (this.economy == null) {
            return false;
        }
        return this.economy.isEnabled();
    }

    @Override
    public String getName() {
        return "iConomy 4";
    }

    @Override
    public String format(double amount) {
        return iConomy.getBank().format(amount);
    }

    @Override
    public String currencyNamePlural() {
        return iConomy.getBank().getCurrency() + "s";
    }

    @Override
    public String currencyNameSingular() {
        return iConomy.getBank().getCurrency();
    }

    @Override
    public double getBalance(String playerName) {
        return this.getAccountBalance(playerName);
    }

    private double getAccountBalance(String playerName) {
        Account account = iConomy.getBank().getAccount(playerName);
        if (account == null) {
            iConomy.getBank().addAccount(playerName);
            account = iConomy.getBank().getAccount(playerName);
        }
        return account.getBalance();
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        String errorMessage = null;
        if (amount < 0.0) {
            errorMessage = "Cannot withdraw negative funds";
            EconomyResponse.ResponseType type = EconomyResponse.ResponseType.FAILURE;
            amount = 0.0;
            double balance = this.getAccountBalance(playerName);
            return new EconomyResponse(amount, balance, type, errorMessage);
        }
        double balance = this.getAccountBalance(playerName);
        if (balance >= amount) {
            Account account = iConomy.getBank().getAccount(playerName);
            if (account == null) {
                return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Could not find account");
            }
            account.subtract(amount);
            EconomyResponse.ResponseType type = EconomyResponse.ResponseType.SUCCESS;
            balance = this.getAccountBalance(playerName);
            return new EconomyResponse(amount, balance, type, errorMessage);
        }
        errorMessage = "Error withdrawing funds";
        EconomyResponse.ResponseType type = EconomyResponse.ResponseType.FAILURE;
        amount = 0.0;
        balance = this.getAccountBalance(playerName);
        return new EconomyResponse(amount, balance, type, errorMessage);
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, double amount) {
        String errorMessage = null;
        if (amount < 0.0) {
            errorMessage = "Cannot deposit negative funds";
            EconomyResponse.ResponseType type = EconomyResponse.ResponseType.FAILURE;
            amount = 0.0;
            double balance = this.getAccountBalance(playerName);
            return new EconomyResponse(amount, balance, type, errorMessage);
        }
        Account account = iConomy.getBank().getAccount(playerName);
        if (account == null) {
            iConomy.getBank().addAccount(playerName);
            account = iConomy.getBank().getAccount(playerName);
        }
        account.add(amount);
        double balance = this.getAccountBalance(playerName);
        EconomyResponse.ResponseType type = EconomyResponse.ResponseType.SUCCESS;
        return new EconomyResponse(amount, balance, type, errorMessage);
    }

    @Override
    public boolean has(String playerName, double amount) {
        return this.getBalance(playerName) >= amount;
    }

    @Override
    public EconomyResponse createBank(String name, String player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "iConomy4 does not support bank accounts!");
    }

    @Override
    public EconomyResponse deleteBank(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "iConomy4 does not support bank accounts!");
    }

    @Override
    public EconomyResponse bankHas(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "iConomy4 does not support bank accounts!");
    }

    @Override
    public EconomyResponse bankWithdraw(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "iConomy4 does not support bank accounts!");
    }

    @Override
    public EconomyResponse bankDeposit(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "iConomy4 does not support bank accounts!");
    }

    @Override
    public EconomyResponse isBankOwner(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "iConomy4 does not support bank accounts!");
    }

    @Override
    public EconomyResponse isBankMember(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "iConomy4 does not support bank accounts!");
    }

    @Override
    public EconomyResponse bankBalance(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "iConomy4 does not support bank accounts!");
    }

    @Override
    public List<String> getBanks() {
        return new ArrayList<String>();
    }

    @Override
    public boolean hasBankSupport() {
        return false;
    }

    @Override
    public boolean hasAccount(String playerName) {
        return iConomy.getBank().hasAccount(playerName);
    }

    @Override
    public boolean createPlayerAccount(String playerName) {
        if (this.hasAccount(playerName)) {
            return false;
        }
        iConomy.getBank().addAccount(playerName);
        return true;
    }

    public class EconomyServerListener
    implements Listener {
        Economy_iConomy4 economy = null;

        public EconomyServerListener(Economy_iConomy4 economy) {
            this.economy = economy;
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginEnable(PluginEnableEvent event) {
            Plugin iConomy2;
            if (this.economy.economy == null && (iConomy2 = Economy_iConomy4.this.plugin.getServer().getPluginManager().getPlugin("iConomy")) != null && iConomy2.isEnabled() && iConomy2.getClass().getName().equals("com.nijiko.coelho.iConomy.iConomy")) {
                this.economy.economy = (iConomy)iConomy2;
                log.info(String.format("[%s][Economy] %s hooked.", Economy_iConomy4.this.plugin.getDescription().getName(), "iConomy 4"));
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginDisable(PluginDisableEvent event) {
            if (this.economy.economy != null && event.getPlugin().getDescription().getName().equals("iConomy")) {
                this.economy.economy = null;
                log.info(String.format("[%s][Economy] %s unhooked.", Economy_iConomy4.this.plugin.getDescription().getName(), "iConomy 4"));
            }
        }
    }
}

