/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault.permission.plugins;

import java.util.ArrayList;
import net.milkbowl.vault.Vault;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.Plugin;
import org.tyrannyofheaven.bukkit.zPermissions.ZPermissionsPlugin;

public class Permission_zPermissions
extends Permission {
    private final String name = "zPermissions";
    private ZPermissionsPlugin perms;
    private final ConsoleCommandSender ccs;

    public Permission_zPermissions(Vault plugin) {
        Plugin p;
        this.plugin = plugin;
        this.ccs = Bukkit.getServer().getConsoleSender();
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new PermissionServerListener(), (Plugin)plugin);
        if (this.perms == null && (p = plugin.getServer().getPluginManager().getPlugin("zPermissions")) != null) {
            this.perms = (ZPermissionsPlugin)p;
            log.info(String.format("[%s][Permission] %s hooked.", plugin.getDescription().getName(), "zPermissions"));
        }
    }

    @Override
    public String getName() {
        return "zPermissions";
    }

    @Override
    public boolean isEnabled() {
        if (this.perms == null) {
            return false;
        }
        return this.perms.isEnabled();
    }

    @Override
    public boolean hasSuperPermsCompat() {
        return true;
    }

    @Override
    public boolean playerHas(String world, String player, String permission) {
        Player p = Bukkit.getServer().getPlayer(player);
        if (p == null) {
            throw new UnsupportedOperationException(this.getName() + " does not support offline player resolution.");
        }
        return this.playerHas(p, permission);
    }

    @Override
    public boolean playerAdd(String world, String player, String permission) {
        if (world != null) {
            return false;
        }
        return this.plugin.getServer().dispatchCommand((CommandSender)this.ccs, "permissions player set " + player + " " + permission);
    }

    @Override
    public boolean playerRemove(String world, String player, String permission) {
        if (world != null) {
            return false;
        }
        return this.plugin.getServer().dispatchCommand((CommandSender)this.ccs, "permissions player unset " + player + " " + permission);
    }

    @Override
    public boolean groupHas(String world, String group, String permission) {
        return false;
    }

    @Override
    public boolean groupAdd(String world, String group, String permission) {
        if (world != null) {
            return false;
        }
        return this.plugin.getServer().dispatchCommand((CommandSender)this.ccs, "permissions group set " + group + " " + permission);
    }

    @Override
    public boolean groupRemove(String world, String group, String permission) {
        if (world != null) {
            return false;
        }
        return this.plugin.getServer().dispatchCommand((CommandSender)this.ccs, "permissions group unset " + group + " " + permission);
    }

    @Override
    public boolean playerInGroup(String world, String player, String group) {
        Player p = Bukkit.getServer().getPlayer(player);
        if (p == null) {
            throw new UnsupportedOperationException(this.getName() + " does not support offline player resolution.");
        }
        return p.hasPermission("group." + group);
    }

    @Override
    public boolean playerAddGroup(String world, String player, String group) {
        if (world != null) {
            return false;
        }
        return this.plugin.getServer().dispatchCommand((CommandSender)this.ccs, "permissions group add " + player);
    }

    @Override
    public boolean playerRemoveGroup(String world, String player, String group) {
        if (world != null) {
            return false;
        }
        return this.plugin.getServer().dispatchCommand((CommandSender)this.ccs, "permissions group remove " + player);
    }

    @Override
    public String[] getPlayerGroups(String world, String player) {
        Player p = Bukkit.getServer().getPlayer(player);
        if (p == null) {
            throw new UnsupportedOperationException(this.getName() + " does not support offline player resolution.");
        }
        ArrayList<String> groups = new ArrayList<String>();
        for (PermissionAttachmentInfo pai : p.getEffectivePermissions()) {
            if (!pai.getPermission().startsWith("group.") || !pai.getValue()) continue;
            groups.add(pai.getPermission().substring(6));
        }
        return groups.toArray(new String[0]);
    }

    @Override
    public String getPrimaryGroup(String world, String player) {
        throw new UnsupportedOperationException(this.getName() + " does not support primary group resolution.");
    }

    @Override
    public String[] getGroups() {
        throw new UnsupportedOperationException(this.getName() + " does not support group resolution.");
    }

    public class PermissionServerListener
    implements Listener {
        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginEnable(PluginEnableEvent event) {
            Plugin p;
            if (Permission_zPermissions.this.perms == null && (p = event.getPlugin()).getDescription().getName().equals("zPermissions") && p.isEnabled()) {
                Permission_zPermissions.this.perms = (ZPermissionsPlugin)p;
                log.info(String.format("[%s][Permission] %s hooked.", Permission_zPermissions.this.plugin.getDescription().getName(), "zPermissions"));
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginDisable(PluginDisableEvent event) {
            if (Permission_zPermissions.this.perms != null && event.getPlugin().getDescription().getName().equals("zPermissions")) {
                Permission_zPermissions.this.perms = null;
                Permission_zPermissions.this.perms = null;
                log.info(String.format("[%s][Permission] %s un-hooked.", Permission_zPermissions.this.plugin.getDescription().getName(), "zPermissions"));
            }
        }
    }
}

