/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault.permission.plugins;

import com.platymuus.bukkit.permissions.Group;
import com.platymuus.bukkit.permissions.PermissionsPlugin;
import java.util.ArrayList;
import net.milkbowl.vault.Vault;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;

public class Permission_PermissionsBukkit
extends Permission {
    private final String name = "PermissionsBukkit";
    private PermissionsPlugin perms = null;

    public Permission_PermissionsBukkit(Vault plugin) {
        Plugin perms;
        this.plugin = plugin;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new PermissionServerListener(this), (Plugin)plugin);
        if (this.perms == null && (perms = plugin.getServer().getPluginManager().getPlugin("PermissionsBukkit")) != null) {
            perms = (PermissionsPlugin)perms;
            log.info(String.format("[%s][Permission] %s hooked.", plugin.getDescription().getName(), "PermissionsBukkit"));
        }
    }

    @Override
    public String getName() {
        return "PermissionsBukkit";
    }

    @Override
    public boolean isEnabled() {
        if (this.perms == null) {
            return false;
        }
        return this.perms.isEnabled();
    }

    @Override
    public boolean playerHas(String world, String player, String permission) {
        if (this.plugin.getServer().getPlayer(player) != null) {
            return this.plugin.getServer().getPlayer(player).hasPermission(permission);
        }
        return false;
    }

    @Override
    public boolean playerAdd(String world, String player, String permission) {
        if (world != null) {
            permission = world + ":" + permission;
        }
        return this.plugin.getServer().dispatchCommand((CommandSender)Bukkit.getServer().getConsoleSender(), "permissions player setperm " + player + " " + permission + " true");
    }

    @Override
    public boolean playerRemove(String world, String player, String permission) {
        if (world != null) {
            permission = world + ":" + permission;
        }
        return this.plugin.getServer().dispatchCommand((CommandSender)Bukkit.getServer().getConsoleSender(), "permissions player unsetperm " + player + " " + permission);
    }

    @Override
    public boolean groupHas(String world, String group, String permission) {
        if (world != null && !world.isEmpty()) {
            return this.perms.getGroup(group).getInfo().getWorldPermissions(world).get(permission) == null ? false : (Boolean)this.perms.getGroup(group).getInfo().getWorldPermissions(world).get(permission);
        }
        if (this.perms.getGroup(group) == null) {
            return false;
        }
        if (this.perms.getGroup(group).getInfo() == null) {
            return false;
        }
        if (this.perms.getGroup(group).getInfo().getPermissions() == null) {
            return false;
        }
        return (Boolean)this.perms.getGroup(group).getInfo().getPermissions().get(permission);
    }

    @Override
    public boolean groupAdd(String world, String group, String permission) {
        if (world != null) {
            permission = world + ":" + permission;
        }
        return this.plugin.getServer().dispatchCommand((CommandSender)Bukkit.getServer().getConsoleSender(), "permissions group setperm " + group + " " + permission + " true");
    }

    @Override
    public boolean groupRemove(String world, String group, String permission) {
        if (world != null) {
            permission = world + ":" + permission;
        }
        return this.plugin.getServer().dispatchCommand((CommandSender)Bukkit.getServer().getConsoleSender(), "permissions group unsetperm " + group + " " + permission);
    }

    @Override
    public boolean playerInGroup(String world, String player, String group) {
        if (world != null) {
            for (Group g : this.perms.getPlayerInfo(player).getGroups()) {
                if (!g.getName().equals(group)) continue;
                return g.getInfo().getWorlds().contains(world);
            }
            return false;
        }
        Group g = this.perms.getGroup(group);
        if (g == null) {
            return false;
        }
        return g.getPlayers().contains(player);
    }

    @Override
    public boolean playerAddGroup(String world, String player, String group) {
        if (world != null) {
            return false;
        }
        return this.plugin.getServer().dispatchCommand((CommandSender)Bukkit.getServer().getConsoleSender(), "permissions player addgroup " + player + " " + group);
    }

    @Override
    public boolean playerRemoveGroup(String world, String player, String group) {
        if (world != null) {
            return false;
        }
        return this.plugin.getServer().dispatchCommand((CommandSender)Bukkit.getServer().getConsoleSender(), "permissions player removegroup " + player + " " + group);
    }

    @Override
    public String[] getPlayerGroups(String world, String player) {
        ArrayList<String> groupList = new ArrayList<String>();
        if (world != null && this.perms.getPlayerInfo(player) != null) {
            for (Group group : this.perms.getPlayerInfo(player).getGroups()) {
                if (!group.getInfo().getWorlds().contains(world)) continue;
                groupList.add(group.getName());
            }
            return groupList.toArray(new String[0]);
        }
        for (Group group : this.perms.getPlayerInfo(player).getGroups()) {
            groupList.add(group.getName());
        }
        return groupList.toArray(new String[0]);
    }

    @Override
    public String getPrimaryGroup(String world, String player) {
        if (this.perms.getPlayerInfo(player) == null) {
            return null;
        }
        if (this.perms.getPlayerInfo(player).getGroups() != null && !this.perms.getPlayerInfo(player).getGroups().isEmpty()) {
            return ((Group)this.perms.getPlayerInfo(player).getGroups().get(0)).getName();
        }
        return null;
    }

    @Override
    public String[] getGroups() {
        ArrayList<String> groupNames = new ArrayList<String>();
        for (Group group : this.perms.getAllGroups()) {
            groupNames.add(group.getName());
        }
        return groupNames.toArray(new String[0]);
    }

    @Override
    public boolean hasSuperPermsCompat() {
        return true;
    }

    public class PermissionServerListener
    implements Listener {
        Permission_PermissionsBukkit permission = null;

        public PermissionServerListener(Permission_PermissionsBukkit permission) {
            this.permission = permission;
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginEnable(PluginEnableEvent event) {
            Plugin perms;
            if (this.permission.perms == null && (perms = Permission_PermissionsBukkit.this.plugin.getServer().getPluginManager().getPlugin("PermissionsBukkit")) != null && perms.isEnabled()) {
                this.permission.perms = (PermissionsPlugin)perms;
                log.info(String.format("[%s][Permission] %s hooked.", Permission_PermissionsBukkit.this.plugin.getDescription().getName(), "PermissionsBukkit"));
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginDisable(PluginDisableEvent event) {
            if (this.permission.perms != null && event.getPlugin().getDescription().getName().equals("PermissionsBukkit")) {
                this.permission.perms = null;
                log.info(String.format("[%s][Permission] %s un-hooked.", Permission_PermissionsBukkit.this.plugin.getDescription().getName(), "PermissionsBukkit"));
            }
        }
    }
}

