/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault.permission.plugins;

import java.util.Collection;
import java.util.HashSet;
import net.milkbowl.vault.Vault;
import net.milkbowl.vault.permission.Permission;
import org.anjocaido.groupmanager.GroupManager;
import org.anjocaido.groupmanager.data.Group;
import org.anjocaido.groupmanager.data.User;
import org.anjocaido.groupmanager.dataholder.OverloadedWorldHolder;
import org.anjocaido.groupmanager.permissions.AnjoPermissionsHandler;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.Plugin;

public class Permission_GroupManager
extends Permission {
    private final String name = "GroupManager";
    private GroupManager groupManager;

    public Permission_GroupManager(Vault plugin) {
        Plugin perms;
        this.plugin = plugin;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new PermissionServerListener(this), (Plugin)plugin);
        if (this.groupManager == null && (perms = plugin.getServer().getPluginManager().getPlugin("GroupManager")) != null && perms.isEnabled()) {
            this.groupManager = (GroupManager)perms;
            log.info(String.format("[%s][Permission] %s hooked.", plugin.getDescription().getName(), "GroupManager"));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isEnabled() {
        return this.groupManager != null && this.groupManager.isEnabled();
    }

    @Override
    public boolean playerHas(String worldName, String playerName, String permission) {
        AnjoPermissionsHandler handler = worldName == null ? this.groupManager.getWorldsHolder().getWorldPermissionsByPlayerName(playerName) : this.groupManager.getWorldsHolder().getWorldPermissions(worldName);
        if (handler == null) {
            return false;
        }
        return handler.permission(playerName, permission);
    }

    @Override
    public boolean playerAdd(String worldName, String playerName, String permission) {
        OverloadedWorldHolder owh = worldName == null ? this.groupManager.getWorldsHolder().getWorldDataByPlayerName(playerName) : this.groupManager.getWorldsHolder().getWorldData(worldName);
        if (owh == null) {
            return false;
        }
        User user = owh.getUser(playerName);
        if (user == null) {
            return false;
        }
        user.addPermission(permission);
        return true;
    }

    @Override
    public boolean playerRemove(String worldName, String playerName, String permission) {
        OverloadedWorldHolder owh = worldName == null ? this.groupManager.getWorldsHolder().getWorldDataByPlayerName(playerName) : this.groupManager.getWorldsHolder().getWorldData(worldName);
        if (owh == null) {
            return false;
        }
        User user = owh.getUser(playerName);
        if (user == null) {
            return false;
        }
        user.removePermission(permission);
        return true;
    }

    @Override
    public boolean groupHas(String worldName, String groupName, String permission) {
        OverloadedWorldHolder owh = worldName == null ? this.groupManager.getWorldsHolder().getDefaultWorld() : this.groupManager.getWorldsHolder().getWorldData(worldName);
        if (owh == null) {
            return false;
        }
        Group group = owh.getGroup(groupName);
        if (group == null) {
            return false;
        }
        return group.hasSamePermissionNode(permission);
    }

    @Override
    public boolean groupAdd(String worldName, String groupName, String permission) {
        OverloadedWorldHolder owh = worldName == null ? this.groupManager.getWorldsHolder().getDefaultWorld() : this.groupManager.getWorldsHolder().getWorldData(worldName);
        if (owh == null) {
            return false;
        }
        Group group = owh.getGroup(groupName);
        if (group == null) {
            return false;
        }
        group.addPermission(permission);
        return true;
    }

    @Override
    public boolean groupRemove(String worldName, String groupName, String permission) {
        OverloadedWorldHolder owh = worldName == null ? this.groupManager.getWorldsHolder().getDefaultWorld() : this.groupManager.getWorldsHolder().getWorldData(worldName);
        if (owh == null) {
            return false;
        }
        Group group = owh.getGroup(groupName);
        if (group == null) {
            return false;
        }
        group.removePermission(permission);
        return true;
    }

    @Override
    public boolean playerInGroup(String worldName, String playerName, String groupName) {
        AnjoPermissionsHandler handler = worldName == null ? this.groupManager.getWorldsHolder().getWorldPermissionsByPlayerName(playerName) : this.groupManager.getWorldsHolder().getWorldPermissions(worldName);
        if (handler == null) {
            return false;
        }
        return handler.inGroup(playerName, groupName);
    }

    @Override
    public boolean playerAddGroup(String worldName, String playerName, String groupName) {
        OverloadedWorldHolder owh = worldName == null ? this.groupManager.getWorldsHolder().getWorldDataByPlayerName(playerName) : this.groupManager.getWorldsHolder().getWorldData(worldName);
        if (owh == null) {
            return false;
        }
        User user = owh.getUser(playerName);
        if (user == null) {
            return false;
        }
        Group group = owh.getGroup(groupName);
        if (group == null) {
            return false;
        }
        if (user.getGroup().equals((Object)owh.getDefaultGroup())) {
            user.setGroup(group);
        } else if (group.getInherits().contains(user.getGroup().getName().toLowerCase())) {
            user.setGroup(group);
        } else {
            user.addSubGroup(group);
        }
        return true;
    }

    @Override
    public boolean playerRemoveGroup(String worldName, String playerName, String groupName) {
        OverloadedWorldHolder owh = worldName == null ? this.groupManager.getWorldsHolder().getWorldDataByPlayerName(playerName) : this.groupManager.getWorldsHolder().getWorldData(worldName);
        if (owh == null) {
            return false;
        }
        User user = owh.getUser(playerName);
        if (user == null) {
            return false;
        }
        if (user.getGroup().getName().equalsIgnoreCase(groupName)) {
            user.setGroup(owh.getDefaultGroup());
            return true;
        }
        Group group = owh.getGroup(groupName);
        if (group == null) {
            return false;
        }
        return user.removeSubGroup(group);
    }

    @Override
    public String[] getPlayerGroups(String worldName, String playerName) {
        AnjoPermissionsHandler handler = worldName == null ? this.groupManager.getWorldsHolder().getWorldPermissionsByPlayerName(playerName) : this.groupManager.getWorldsHolder().getWorldPermissions(worldName);
        return handler.getGroups(playerName);
    }

    @Override
    public String getPrimaryGroup(String worldName, String playerName) {
        AnjoPermissionsHandler handler = worldName == null ? this.groupManager.getWorldsHolder().getWorldPermissionsByPlayerName(playerName) : this.groupManager.getWorldsHolder().getWorldPermissions(worldName);
        return handler.getGroup(playerName);
    }

    @Override
    public boolean playerAddTransient(String world, String player, String permission) {
        if (world != null) {
            throw new UnsupportedOperationException(this.getName() + " does not support World based transient permissions!");
        }
        Player p = this.plugin.getServer().getPlayer(player);
        if (p == null) {
            throw new UnsupportedOperationException(this.getName() + " does not support offline player transient permissions!");
        }
        for (PermissionAttachmentInfo paInfo : p.getEffectivePermissions()) {
            if (!paInfo.getAttachment().getPlugin().equals((Object)this.plugin)) continue;
            paInfo.getAttachment().setPermission(permission, true);
            return true;
        }
        PermissionAttachment attach = p.addAttachment((Plugin)this.plugin);
        attach.setPermission(permission, true);
        return true;
    }

    @Override
    public boolean playerRemoveTransient(String world, String player, String permission) {
        if (world != null) {
            throw new UnsupportedOperationException(this.getName() + " does not support World based transient permissions!");
        }
        Player p = this.plugin.getServer().getPlayer(player);
        if (p == null) {
            throw new UnsupportedOperationException(this.getName() + " does not support offline player transient permissions!");
        }
        for (PermissionAttachmentInfo paInfo : p.getEffectivePermissions()) {
            if (!paInfo.getAttachment().getPlugin().equals((Object)this.plugin)) continue;
            return (Boolean)paInfo.getAttachment().getPermissions().remove(permission);
        }
        return false;
    }

    @Override
    public String[] getGroups() {
        HashSet<String> groupNames = new HashSet<String>();
        for (World world : Bukkit.getServer().getWorlds()) {
            Collection groups = this.groupManager.getWorldsHolder().getWorldData(world.getName()).getGroupList();
            for (Group group : groups) {
                groupNames.add(group.getName());
            }
        }
        return groupNames.toArray(new String[0]);
    }

    @Override
    public boolean hasSuperPermsCompat() {
        return true;
    }

    public class PermissionServerListener
    implements Listener {
        Permission_GroupManager permission = null;

        public PermissionServerListener(Permission_GroupManager permission) {
            this.permission = permission;
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginEnable(PluginEnableEvent event) {
            Plugin perms;
            if (this.permission.groupManager == null && (perms = Permission_GroupManager.this.plugin.getServer().getPluginManager().getPlugin("GroupManager")) != null && perms.isEnabled()) {
                this.permission.groupManager = (GroupManager)perms;
                log.info(String.format("[%s][Permission] %s hooked.", Permission_GroupManager.this.plugin.getDescription().getName(), "GroupManager"));
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginDisable(PluginDisableEvent event) {
            if (this.permission.groupManager != null && event.getPlugin().getDescription().getName().equals("GroupManager")) {
                this.permission.groupManager = null;
                log.info(String.format("[%s][Permission] %s un-hooked.", Permission_GroupManager.this.plugin.getDescription().getName(), "GroupManager"));
            }
        }
    }
}

