/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault.economy.plugins;

import com.iConomy.iConomy;
import com.iConomy.system.Account;
import com.iConomy.system.Holdings;
import com.iConomy.util.Constants;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Economy_iConomy5
implements Economy {
    private static final Logger log = Logger.getLogger("Minecraft");
    private final String name = "iConomy 5";
    private JavaPlugin plugin = null;
    protected iConomy economy = null;

    public Economy_iConomy5(JavaPlugin plugin) {
        Plugin ec;
        this.plugin = plugin;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new EconomyServerListener(this), (Plugin)plugin);
        log.log(Level.SEVERE, "iConomy5 is outdated and WILL BREAK in CB-R5+ - It is highly recommended to update to a new economy plugin and use Vaults conversion!");
        if (this.economy == null && (ec = plugin.getServer().getPluginManager().getPlugin("iConomy")) != null && ec.isEnabled() && ec.getClass().getName().equals("com.iConomy.iConomy")) {
            this.economy = (iConomy)ec;
            log.info(String.format("[%s][Economy] %s hooked.", plugin.getDescription().getName(), "iConomy 5"));
        }
    }

    @Override
    public boolean isEnabled() {
        if (this.economy == null) {
            return false;
        }
        return this.economy.isEnabled();
    }

    @Override
    public String getName() {
        return "iConomy 5";
    }

    private double getAccountBalance(String playerName) {
        return iConomy.getAccount((String)playerName).getHoldings().balance();
    }

    @Override
    public double getBalance(String playerName) {
        return this.getAccountBalance(playerName);
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        String errorMessage = null;
        Account account = iConomy.getAccount((String)playerName);
        Holdings holdings = account.getHoldings();
        if (holdings.hasEnough(amount)) {
            holdings.subtract(amount);
            double balance = this.getAccountBalance(playerName);
            EconomyResponse.ResponseType type = EconomyResponse.ResponseType.SUCCESS;
            return new EconomyResponse(amount, balance, type, errorMessage);
        }
        amount = 0.0;
        double balance = this.getAccountBalance(playerName);
        EconomyResponse.ResponseType type = EconomyResponse.ResponseType.FAILURE;
        errorMessage = "Insufficient funds";
        return new EconomyResponse(amount, balance, type, errorMessage);
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, double amount) {
        String errorMessage = null;
        Account account = iConomy.getAccount((String)playerName);
        Holdings holdings = account.getHoldings();
        holdings.add(amount);
        double balance = this.getAccountBalance(playerName);
        EconomyResponse.ResponseType type = EconomyResponse.ResponseType.SUCCESS;
        return new EconomyResponse(amount, balance, type, errorMessage);
    }

    @Override
    public String format(double amount) {
        return iConomy.format((double)amount);
    }

    @Override
    public String currencyNameSingular() {
        try {
            return (String)Constants.Major.get(0);
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String currencyNamePlural() {
        try {
            return (String)Constants.Major.get(1);
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public boolean has(String playerName, double amount) {
        return this.getBalance(playerName) >= amount;
    }

    @Override
    public EconomyResponse createBank(String name, String player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "iConomy5 does not support single account banks!");
    }

    @Override
    public EconomyResponse deleteBank(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "iConomy5 does not support bank accounts!");
    }

    @Override
    public EconomyResponse bankHas(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "iConomy5 does not support single bank accounts!");
    }

    @Override
    public EconomyResponse bankWithdraw(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "iConomy5 does not support single bank accounts!");
    }

    @Override
    public EconomyResponse bankDeposit(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "iConomy5 does not support single bank accounts!");
    }

    @Override
    public EconomyResponse isBankOwner(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "iConomy5 does not support single bank accounts!");
    }

    @Override
    public EconomyResponse isBankMember(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "iConomy5 does not support single bank accounts!");
    }

    @Override
    public EconomyResponse bankBalance(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "iConomy5 does not support single bank accounts!");
    }

    @Override
    public List<String> getBanks() {
        return new ArrayList<String>();
    }

    @Override
    public boolean hasBankSupport() {
        return false;
    }

    @Override
    public boolean hasAccount(String playerName) {
        return iConomy.hasAccount((String)playerName);
    }

    @Override
    public boolean createPlayerAccount(String playerName) {
        if (this.hasAccount(playerName)) {
            return false;
        }
        iConomy.getAccount((String)playerName);
        return true;
    }

    public class EconomyServerListener
    implements Listener {
        Economy_iConomy5 economy = null;

        public EconomyServerListener(Economy_iConomy5 economy) {
            this.economy = economy;
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginEnable(PluginEnableEvent event) {
            Plugin ec;
            if (this.economy.economy == null && (ec = Economy_iConomy5.this.plugin.getServer().getPluginManager().getPlugin("iConomy")) != null && ec.isEnabled() && ec.getClass().getName().equals("com.iConomy.iConomy")) {
                this.economy.economy = (iConomy)ec;
                log.info(String.format("[%s][Economy] %s hooked.", Economy_iConomy5.this.plugin.getDescription().getName(), "iConomy 5"));
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginDisable(PluginDisableEvent event) {
            if (this.economy.economy != null && event.getPlugin().getDescription().getName().equals("iConomy")) {
                this.economy.economy = null;
                log.info(String.format("[%s][Economy] %s unhooked.", Economy_iConomy5.this.plugin.getDescription().getName(), "iConomy 5"));
            }
        }
    }
}

