/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault.economy.plugins;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import me.mjolnir.mineconomy.Accounting;
import me.mjolnir.mineconomy.MineConomy;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;

public class Economy_MineConomy
implements Economy {
    private static final Logger log = Logger.getLogger("Minecraft");
    private final String name = "MineConomy";
    private Plugin plugin = null;
    private MineConomy econ = null;

    public Economy_MineConomy(Plugin plugin) {
        Plugin econ;
        this.plugin = plugin;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new EconomyServerListener(this), plugin);
        if (this.econ == null && (econ = plugin.getServer().getPluginManager().getPlugin("MineConomy")) != null && econ.isEnabled()) {
            this.econ = (MineConomy)econ;
            log.info(String.format("[%s][Economy] %s hooked.", plugin.getDescription().getName(), "MineConomy"));
        }
    }

    @Override
    public boolean isEnabled() {
        return this.econ != null;
    }

    @Override
    public String getName() {
        return "MineConomy";
    }

    @Override
    public String format(double amount) {
        return String.valueOf(amount);
    }

    @Override
    public String currencyNameSingular() {
        return "";
    }

    @Override
    public String currencyNamePlural() {
        return "";
    }

    @Override
    public double getBalance(String playerName) {
        return Accounting.getBalance((String)playerName, (File)MineConomy.accounts);
    }

    @Override
    public boolean has(String playerName, double amount) {
        return this.getBalance(playerName) >= amount;
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        double balance = this.getBalance(playerName);
        if (amount < 0.0) {
            return new EconomyResponse(0.0, balance, EconomyResponse.ResponseType.FAILURE, "Cannot withdraw negative funds");
        }
        if (balance >= amount) {
            double finalBalance = balance - amount;
            Accounting.setBalance((String)playerName, (double)finalBalance, (File)MineConomy.accounts);
            return new EconomyResponse(amount, finalBalance, EconomyResponse.ResponseType.SUCCESS, null);
        }
        return new EconomyResponse(0.0, balance, EconomyResponse.ResponseType.FAILURE, "Insufficient funds");
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, double amount) {
        double balance = this.getBalance(playerName);
        if (amount < 0.0) {
            return new EconomyResponse(0.0, balance, EconomyResponse.ResponseType.FAILURE, "Cannot deposit negative funds");
        }
        Accounting.setBalance((String)playerName, (double)(balance += amount), (File)MineConomy.accounts);
        return new EconomyResponse(amount, balance, EconomyResponse.ResponseType.SUCCESS, null);
    }

    @Override
    public EconomyResponse createBank(String name, String player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "MineConomy does not support bank accounts!");
    }

    @Override
    public EconomyResponse deleteBank(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "MineConomy does not support bank accounts!");
    }

    @Override
    public EconomyResponse bankHas(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "MineConomy does not support bank accounts!");
    }

    @Override
    public EconomyResponse bankWithdraw(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "MineConomy does not support bank accounts!");
    }

    @Override
    public EconomyResponse bankDeposit(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "MineConomy does not support bank accounts!");
    }

    @Override
    public EconomyResponse isBankOwner(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "MineConomy does not support bank accounts!");
    }

    @Override
    public EconomyResponse isBankMember(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "MineConomy does not support bank accounts!");
    }

    @Override
    public EconomyResponse bankBalance(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "MineConomy does not support bank accounts!");
    }

    @Override
    public List<String> getBanks() {
        return new ArrayList<String>();
    }

    @Override
    public boolean hasBankSupport() {
        return false;
    }

    @Override
    public boolean hasAccount(String playerName) {
        return Accounting.containsKey((String)playerName, (File)MineConomy.accounts);
    }

    @Override
    public boolean createPlayerAccount(String playerName) {
        if (this.hasAccount(playerName)) {
            return false;
        }
        Accounting.setBalance((String)playerName, (double)0.0, (File)MineConomy.accounts);
        return true;
    }

    public class EconomyServerListener
    implements Listener {
        Economy_MineConomy economy = null;

        public EconomyServerListener(Economy_MineConomy economy) {
            this.economy = economy;
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginEnable(PluginEnableEvent event) {
            Plugin eco;
            if (this.economy.econ == null && (eco = Economy_MineConomy.this.plugin.getServer().getPluginManager().getPlugin("MineConomy")) != null && eco.isEnabled()) {
                this.economy.econ = (MineConomy)eco;
                log.info(String.format("[%s][Economy] %s hooked.", Economy_MineConomy.this.plugin.getDescription().getName(), "MineConomy"));
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginDisable(PluginDisableEvent event) {
            if (this.economy.econ != null && event.getPlugin().getDescription().getName().equals("MineConomy")) {
                this.economy.econ = null;
                log.info(String.format("[%s][Economy] %s unhooked.", Economy_MineConomy.this.plugin.getDescription().getName(), "MineConomy"));
            }
        }
    }
}

