/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault.economy.plugins;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.ic3d.eco.ECO;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;

public class Economy_3co
implements Economy {
    private static final Logger log = Logger.getLogger("Minecraft");
    private final String name = "3co";
    private Plugin plugin = null;
    private ECO economy = null;

    public Economy_3co(Plugin plugin) {
        Plugin econ;
        this.plugin = plugin;
        log.log(Level.SEVERE, "3co is outdated and WILL BREAK in CB-R5+ - It is highly recommended to update to a new economy plugin and use Vaults conversion!");
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new EconomyServerListener(this), plugin);
        if (this.economy == null && (econ = plugin.getServer().getPluginManager().getPlugin("3co")) != null && econ.isEnabled()) {
            this.economy = (ECO)econ;
            log.info(String.format("[%s][Economy] %s hooked.", plugin.getDescription().getName(), "3co"));
        }
    }

    @Override
    public String getName() {
        return "3co";
    }

    @Override
    public boolean isEnabled() {
        if (this.economy == null) {
            return false;
        }
        return this.economy.isEnabled();
    }

    @Override
    public double getBalance(String playerName) {
        double balance;
        double fBalance = balance = (double)this.economy.getMoney(this.plugin.getServer().getPlayer(playerName)).intValue();
        return fBalance;
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        String errorMessage = null;
        if (amount < 0.0) {
            errorMessage = "Cannot withdraw negative funds";
            EconomyResponse.ResponseType type = EconomyResponse.ResponseType.FAILURE;
            amount = 0.0;
            double balance = this.economy.getMoney(this.plugin.getServer().getPlayer(playerName)).intValue();
            return new EconomyResponse(amount, balance, type, errorMessage);
        }
        amount = Math.ceil(amount);
        double balance = this.economy.getMoney(this.plugin.getServer().getPlayer(playerName)).intValue();
        if (balance - amount < 0.0) {
            errorMessage = "Insufficient funds";
            EconomyResponse.ResponseType type = EconomyResponse.ResponseType.FAILURE;
            amount = 0.0;
            balance = this.economy.getMoney(this.plugin.getServer().getPlayer(playerName)).intValue();
            return new EconomyResponse(amount, balance, type, errorMessage);
        }
        this.economy.setMoney(this.plugin.getServer().getPlayer(playerName), Integer.valueOf((int)(balance - amount)));
        EconomyResponse.ResponseType type = EconomyResponse.ResponseType.SUCCESS;
        balance = this.economy.getMoney(this.plugin.getServer().getPlayer(playerName)).intValue();
        return new EconomyResponse(amount, balance, type, errorMessage);
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, double amount) {
        String errorMessage = null;
        if (amount < 0.0) {
            errorMessage = "Cannot deposit negative funds";
            EconomyResponse.ResponseType type = EconomyResponse.ResponseType.FAILURE;
            amount = 0.0;
            double balance = this.economy.getMoney(this.plugin.getServer().getPlayer(playerName)).intValue();
            return new EconomyResponse(amount, balance, type, errorMessage);
        }
        amount = Math.ceil(amount);
        double balance = this.economy.getMoney(this.plugin.getServer().getPlayer(playerName)).intValue();
        this.economy.setMoney(this.plugin.getServer().getPlayer(playerName), Integer.valueOf((int)(balance + amount)));
        EconomyResponse.ResponseType type = EconomyResponse.ResponseType.SUCCESS;
        balance = this.economy.getMoney(this.plugin.getServer().getPlayer(playerName)).intValue();
        return new EconomyResponse(amount, balance, type, errorMessage);
    }

    @Override
    public String currencyNamePlural() {
        return this.economy.getPluralCurrency();
    }

    @Override
    public String currencyNameSingular() {
        return this.economy.getSingularCurrency();
    }

    @Override
    public String format(double amount) {
        if ((amount = Math.ceil(amount)) == 1.0) {
            return String.format("%d %s", (int)amount, this.currencyNameSingular());
        }
        return String.format("%d %s", (int)amount, this.currencyNamePlural());
    }

    @Override
    public EconomyResponse createBank(String name, String player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "3co does not support bank accounts!");
    }

    @Override
    public EconomyResponse deleteBank(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "3co does not support bank accounts!");
    }

    @Override
    public EconomyResponse bankHas(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "3co does not support bank accounts!");
    }

    @Override
    public EconomyResponse bankWithdraw(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "3co does not support bank accounts!");
    }

    @Override
    public EconomyResponse bankDeposit(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "3co does not support bank accounts!");
    }

    @Override
    public boolean has(String playerName, double amount) {
        return this.getBalance(playerName) >= amount;
    }

    @Override
    public EconomyResponse isBankOwner(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "3co does not support bank accounts!");
    }

    @Override
    public EconomyResponse isBankMember(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "3co does not support bank accounts!");
    }

    @Override
    public EconomyResponse bankBalance(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "3co does not support bank accounts!");
    }

    @Override
    public List<String> getBanks() {
        return new ArrayList<String>();
    }

    @Override
    public boolean hasBankSupport() {
        return false;
    }

    @Override
    public boolean hasAccount(String playerName) {
        return this.economy.hasAccount(this.plugin.getServer().getPlayer(playerName));
    }

    @Override
    public boolean createPlayerAccount(String playerName) {
        Player p = Bukkit.getPlayer((String)playerName);
        if (p == null) {
            return false;
        }
        this.economy.createAccount(p, Integer.valueOf(0));
        return true;
    }

    public class EconomyServerListener
    implements Listener {
        Economy_3co economy = null;

        public EconomyServerListener(Economy_3co economy) {
            this.economy = economy;
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginEnable(PluginEnableEvent event) {
            Plugin eco;
            if (this.economy.economy == null && (eco = Economy_3co.this.plugin.getServer().getPluginManager().getPlugin("3co")) != null && eco.isEnabled()) {
                this.economy.economy = (ECO)eco;
                log.info(String.format("[%s][Economy] %s hooked.", Economy_3co.this.plugin.getDescription().getName(), "3co"));
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginDisable(PluginDisableEvent event) {
            if (this.economy.economy != null && event.getPlugin().getDescription().getName().equals("3co")) {
                this.economy.economy = null;
                log.info(String.format("[%s][Economy] %s unhooked.", Economy_3co.this.plugin.getDescription().getName(), "3co"));
            }
        }
    }
}

